/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject;

import conductor.org.elasticsearch.common.inject.Initializable;
import conductor.org.elasticsearch.common.inject.Provider;
import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.internal.ErrorsException;
import conductor.org.elasticsearch.common.inject.internal.InternalContext;
import conductor.org.elasticsearch.common.inject.internal.InternalFactory;
import conductor.org.elasticsearch.common.inject.internal.SourceProvider;
import conductor.org.elasticsearch.common.inject.spi.Dependency;
import java.util.Objects;

class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Initializable<Provider<? extends T>> initializable;
    private final Object source;

    InternalFactoryToProviderAdapter(Initializable<Provider<? extends T>> initializable) {
        this(initializable, SourceProvider.UNKNOWN_SOURCE);
    }

    InternalFactoryToProviderAdapter(Initializable<Provider<? extends T>> initializable, Object source) {
        this.initializable = Objects.requireNonNull(initializable, "provider");
        this.source = Objects.requireNonNull(source, "source");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        try {
            return errors.checkForNull(this.initializable.get(errors).get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

