/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.settings;

import conductor.joptsimple.OptionSet;
import conductor.org.elasticsearch.cli.EnvironmentAwareCommand;
import conductor.org.elasticsearch.cli.Terminal;
import conductor.org.elasticsearch.common.settings.KeyStoreWrapper;
import conductor.org.elasticsearch.env.Environment;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

class CreateKeyStoreCommand
extends EnvironmentAwareCommand {
    CreateKeyStoreCommand() {
        super("Creates a new elasticsearch keystore");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Path keystoreFile = KeyStoreWrapper.keystorePath(env.configFile());
        if (Files.exists(keystoreFile, new LinkOption[0]) && !terminal.promptYesNo("An elasticsearch keystore already exists. Overwrite?", false)) {
            terminal.println("Exiting without creating keystore.");
            return;
        }
        char[] password = new char[]{};
        KeyStoreWrapper keystore = KeyStoreWrapper.create();
        keystore.save(env.configFile(), password);
        terminal.println("Created elasticsearch keystore in " + env.configFile());
    }
}

