/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.xcontent.cbor;

import conductor.com.fasterxml.jackson.core.JsonEncoding;
import conductor.com.fasterxml.jackson.core.JsonFactory;
import conductor.com.fasterxml.jackson.core.JsonGenerator;
import conductor.com.fasterxml.jackson.core.JsonParser;
import conductor.com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentGenerator;
import conductor.org.elasticsearch.common.xcontent.XContentParseException;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.common.xcontent.cbor.CborXContentGenerator;
import conductor.org.elasticsearch.common.xcontent.cbor.CborXContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;

public class CborXContent
implements XContent {
    static final CBORFactory cborFactory = new CBORFactory();
    public static final CborXContent cborXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(cborXContent);
    }

    private CborXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.CBOR;
    }

    @Override
    public byte streamSeparator() {
        throw new XContentParseException("cbor does not support stream parsing...");
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new CborXContentGenerator(cborFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(new StringReader(content)));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(data));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(data, offset, length));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(reader));
    }

    static {
        cborFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        cborFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        cborFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, XContent.isStrictDuplicateDetectionEnabled());
        cborXContent = new CborXContent();
    }
}

