/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import conductor.org.apache.lucene.util.CharsRef;
import conductor.org.apache.lucene.util.CharsRefBuilder;
import java.io.IOException;

public class ESWordnetSynonymParser
extends WordnetSynonymParser {
    private static final Logger logger = LogManager.getLogger(ESWordnetSynonymParser.class);
    private final boolean lenient;

    public ESWordnetSynonymParser(boolean dedup, boolean expand, boolean lenient, Analyzer analyzer) {
        super(dedup, expand, analyzer);
        this.lenient = lenient;
    }

    @Override
    public void add(CharsRef input, CharsRef output, boolean includeOrig) {
        if (!this.lenient || input.length > 0 && output.length > 0) {
            super.add(input, output, includeOrig);
        }
    }

    @Override
    public CharsRef analyze(String text, CharsRefBuilder reuse) throws IOException {
        try {
            return super.analyze(text, reuse);
        }
        catch (IllegalArgumentException ex) {
            if (this.lenient) {
                logger.info("Synonym rule for [" + text + "] was ignored");
                return new CharsRef("");
            }
            throw ex;
        }
    }
}

