/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.store.ByteArrayDataInput;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.index.fielddata.AtomicFieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

final class BytesBinaryDVAtomicFieldData
implements AtomicFieldData {
    private final BinaryDocValues values;

    BytesBinaryDVAtomicFieldData(BinaryDocValues values) {
        this.values = values;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        return new SortedBinaryDocValues(){
            int count;
            final ByteArrayDataInput in = new ByteArrayDataInput();
            final BytesRef scratch = new BytesRef();

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (BytesBinaryDVAtomicFieldData.this.values.advanceExact(doc)) {
                    BytesRef bytes = BytesBinaryDVAtomicFieldData.this.values.binaryValue();
                    assert (bytes.length > 0);
                    this.in.reset(bytes.bytes, bytes.offset, bytes.length);
                    this.count = this.in.readVInt();
                    this.scratch.bytes = bytes.bytes;
                    return true;
                }
                return false;
            }

            @Override
            public int docValueCount() {
                return this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                return this.scratch;
            }
        };
    }

    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.BytesRefs(this.getBytesValues());
    }

    @Override
    public void close() {
    }
}

