/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.support.replication.ReplicationRequest;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.json.JsonXContent;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.index.query.QueryBuilders;
import conductor.org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import conductor.org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import conductor.org.elasticsearch.index.reindex.ReindexAction;
import conductor.org.elasticsearch.index.reindex.ReindexRequest;
import conductor.org.elasticsearch.index.reindex.RemoteInfo;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.script.Script;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction> {
    static final ObjectParser<ReindexRequest, Void> PARSER = new ObjectParser("reindex");
    private static final Pattern HOST_PATTERN = Pattern.compile("(?<scheme>[^:]+)://(?<host>[^:]+):(?<port>\\d+)(?<pathPrefix>/.*)?");

    public RestReindexAction(Settings settings, RestController controller) {
        super(settings, ReindexAction.INSTANCE);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex", this);
    }

    @Override
    public String getName() {
        return "reindex_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request) throws IOException {
        if (request.hasParam("pipeline")) {
            throw new IllegalArgumentException("_reindex doesn't support [pipeline] as a query parameter. Specify it in the [dest] object instead.");
        }
        ReindexRequest internal = new ReindexRequest();
        try (XContentParser parser = request.contentParser();){
            PARSER.parse(parser, internal, null);
        }
        if (request.hasParam("scroll")) {
            internal.setScroll(TimeValue.parseTimeValue(request.param("scroll"), "scroll"));
        }
        return internal;
    }

    static RemoteInfo buildRemoteInfo(Map<String, Object> source) throws IOException {
        Map remote = (Map)source.remove("remote");
        if (remote == null) {
            return null;
        }
        String username = RestReindexAction.extractString(remote, "username");
        String password = RestReindexAction.extractString(remote, "password");
        String hostInRequest = Objects.requireNonNull(RestReindexAction.extractString(remote, "host"), "[host] must be specified to reindex from a remote cluster");
        Matcher hostMatcher = HOST_PATTERN.matcher(hostInRequest);
        if (!hostMatcher.matches()) {
            throw new IllegalArgumentException("[host] must be of the form [scheme]://[host]:[port](/[pathPrefix])? but was [" + hostInRequest + "]");
        }
        String scheme = hostMatcher.group("scheme");
        String host = hostMatcher.group("host");
        String pathPrefix = hostMatcher.group("pathPrefix");
        int port = Integer.parseInt(hostMatcher.group("port"));
        Map<String, String> headers = RestReindexAction.extractStringStringMap(remote, "headers");
        TimeValue socketTimeout = RestReindexAction.extractTimeValue(remote, "socket_timeout", RemoteInfo.DEFAULT_SOCKET_TIMEOUT);
        TimeValue connectTimeout = RestReindexAction.extractTimeValue(remote, "connect_timeout", RemoteInfo.DEFAULT_CONNECT_TIMEOUT);
        if (!remote.isEmpty()) {
            throw new IllegalArgumentException("Unsupported fields in [remote]: [" + Strings.collectionToCommaDelimitedString(remote.keySet()) + "]");
        }
        return new RemoteInfo(scheme, host, port, pathPrefix, RestReindexAction.queryForRemote(source), username, password, headers, socketTimeout, connectTimeout);
    }

    private static String[] extractStringArray(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.toArray(new String[list.size()]);
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a list of a string but was [" + value + ']');
    }

    private static String extractString(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a string but was [" + value + "]");
    }

    private static Map<String, String> extractStringStringMap(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but was [" + value + "]");
        }
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but has [" + entry + "]");
        }
        Map safe = map;
        return safe;
    }

    private static TimeValue extractTimeValue(Map<String, Object> source, String name, TimeValue defaultValue) {
        String string = RestReindexAction.extractString(source, name);
        return string == null ? defaultValue : TimeValue.parseTimeValue(string, name);
    }

    private static BytesReference queryForRemote(Map<String, Object> source) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
        Object query = source.remove("query");
        if (query == null) {
            return BytesReference.bytes(QueryBuilders.matchAllQuery().toXContent(builder, ToXContent.EMPTY_PARAMS));
        }
        if (!(query instanceof Map)) {
            throw new IllegalArgumentException("Expected [query] to be an object but was [" + query + "]");
        }
        Map map = (Map)query;
        return BytesReference.bytes(builder.map(map));
    }

    static {
        ObjectParser.Parser<ReindexRequest, Void> sourceParser = (parser, request, context) -> {
            String[] types;
            Map<String, Object> source = parser.map();
            String[] indices = RestReindexAction.extractStringArray(source, "index");
            if (indices != null) {
                request.getSearchRequest().indices(indices);
            }
            if ((types = RestReindexAction.extractStringArray(source, "type")) != null) {
                request.getSearchRequest().types(types);
            }
            request.setRemoteInfo(RestReindexAction.buildRemoteInfo(source));
            XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());
            builder.map(source);
            try (StreamInput stream = BytesReference.bytes(builder).streamInput();
                 XContentParser innerParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), stream);){
                request.getSearchRequest().source().parseXContent(innerParser, false);
            }
        };
        ObjectParser destParser = new ObjectParser("dest");
        destParser.declareString(ReplicationRequest::index, new ParseField("index", new String[0]));
        destParser.declareString(IndexRequest::type, new ParseField("type", new String[0]));
        destParser.declareString(IndexRequest::routing, new ParseField("routing", new String[0]));
        destParser.declareString(IndexRequest::opType, new ParseField("op_type", new String[0]));
        destParser.declareString(IndexRequest::setPipeline, new ParseField("pipeline", new String[0]));
        destParser.declareString((s, i) -> s.versionType(VersionType.fromString(i)), new ParseField("version_type", new String[0]));
        PARSER.declareField(sourceParser::parse, new ParseField("source", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((p, v, c) -> destParser.parse(p, v.getDestination(), c), new ParseField("dest", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareInt(AbstractBulkByScrollRequest::setSize, new ParseField("size", new String[0]));
        PARSER.declareField((p, v, c) -> v.setScript(Script.parse(p)), new ParseField("script", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString(AbstractBulkByScrollRequest::setConflicts, new ParseField("conflicts", new String[0]));
    }
}

