/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.search;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.join.BitSetProducer;
import conductor.org.apache.lucene.search.join.ScoreMode;
import conductor.org.apache.lucene.search.join.ToParentBlockJoinQuery;
import java.io.IOException;
import java.util.Objects;

public final class ESToParentBlockJoinQuery
extends Query {
    private final ToParentBlockJoinQuery query;
    private final String path;

    public ESToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode, String path) {
        this(new ToParentBlockJoinQuery(childQuery, parentsFilter, scoreMode), path);
    }

    private ESToParentBlockJoinQuery(ToParentBlockJoinQuery query, String path) {
        this.query = query;
        this.path = path;
    }

    public Query getChildQuery() {
        return this.query.getChildQuery();
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query innerRewrite = this.query.rewrite(reader);
        if (innerRewrite != this.query) {
            if (innerRewrite instanceof ToParentBlockJoinQuery) {
                return new ESToParentBlockJoinQuery((ToParentBlockJoinQuery)innerRewrite, this.path);
            }
            return innerRewrite;
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return this.query.createWeight(searcher, needsScores, boost);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ESToParentBlockJoinQuery that = (ESToParentBlockJoinQuery)obj;
        return this.query.equals(that.query) && Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.query, this.path);
    }

    @Override
    public String toString(String field) {
        return this.query.toString(field);
    }
}

