/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.seqno;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.apache.lucene.store.AlreadyClosedException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.replication.ReplicationOperation;
import conductor.org.elasticsearch.action.support.replication.ReplicationRequest;
import conductor.org.elasticsearch.action.support.replication.ReplicationResponse;
import conductor.org.elasticsearch.action.support.replication.TransportReplicationAction;
import conductor.org.elasticsearch.cluster.action.shard.ShardStateAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.concurrent.ThreadContext;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.IndexShardClosedException;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, () -> new Request(), () -> new Request(), "management");
    }

    public void updateGlobalCheckpointForShard(ShardId shardId) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute(new Request(shardId), ActionListener.wrap(r -> {}, e -> {
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                    this.logger.info(new ParameterizedMessage("{} global checkpoint sync failed", (Object)shardId), (Throwable)e);
                }
            }));
        }
    }

    @Override
    protected ReplicationResponse newResponseInstance() {
        return new ReplicationResponse();
    }

    @Override
    protected void sendReplicaRequest(TransportReplicationAction.ConcreteReplicaRequest<Request> replicaRequest, DiscoveryNode node, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
        if (node.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            super.sendReplicaRequest(replicaRequest, node, listener);
        } else {
            long pre60NodeCheckpoint = -3L;
            listener.onResponse(new TransportReplicationAction.ReplicaResponse(-3L, -3L));
        }
    }

    @Override
    protected TransportReplicationAction.PrimaryResult<Request, ReplicationResponse> shardOperationOnPrimary(Request request, IndexShard indexShard) throws Exception {
        this.maybeSyncTranslog(indexShard);
        return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(Request request, IndexShard indexShard) throws Exception {
        this.maybeSyncTranslog(indexShard);
        return new TransportReplicationAction.ReplicaResult();
    }

    private void maybeSyncTranslog(IndexShard indexShard) throws IOException {
        if (indexShard.getTranslogDurability() == Translog.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getGlobalCheckpoint()) {
            indexShard.sync();
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private Request() {
        }

        public Request(ShardId shardId) {
            super(shardId);
        }

        @Override
        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", waitForActiveShards=" + this.waitForActiveShards + "}";
        }
    }
}

