/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.translog;

import conductor.org.elasticsearch.common.unit.ByteSizeUnit;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.nio.file.Path;

public final class TranslogConfig {
    public static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(8L, ByteSizeUnit.KB);
    private final BigArrays bigArrays;
    private final IndexSettings indexSettings;
    private final ShardId shardId;
    private final Path translogPath;
    private final ByteSizeValue bufferSize;

    public TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays) {
        this(shardId, translogPath, indexSettings, bigArrays, DEFAULT_BUFFER_SIZE);
    }

    TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays, ByteSizeValue bufferSize) {
        this.bufferSize = bufferSize;
        this.indexSettings = indexSettings;
        this.shardId = shardId;
        this.translogPath = translogPath;
        this.bigArrays = bigArrays;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public Path getTranslogPath() {
        return this.translogPath;
    }

    public ByteSizeValue getBufferSize() {
        return this.bufferSize;
    }
}

