/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.repositories.blobstore;

import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.common.CheckedFunction;
import conductor.org.elasticsearch.common.blobstore.BlobContainer;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public abstract class BlobStoreFormat<T extends ToXContent> {
    protected final String blobNameFormat;
    protected final CheckedFunction<XContentParser, T, IOException> reader;
    protected final NamedXContentRegistry namedXContentRegistry;
    protected static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;

    protected BlobStoreFormat(String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public abstract T readBlob(BlobContainer var1, String var2) throws IOException;

    public T read(BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        return this.readBlob(blobContainer, blobName);
    }

    public void delete(BlobContainer blobContainer, String name) throws IOException {
        blobContainer.deleteBlob(this.blobName(name));
    }

    public boolean exists(BlobContainer blobContainer, String name) throws IOException {
        return blobContainer.blobExists(this.blobName(name));
    }

    protected String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    protected T read(BytesReference bytes) throws IOException {
        try (XContentParser parser = XContentHelper.createParser(this.namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes);){
            ToXContent obj;
            ToXContent toXContent = obj = (ToXContent)this.reader.apply(parser);
            return (T)toXContent;
        }
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", MetaData.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

