/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequestBuilder;
import conductor.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestActions;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;

public final class RestReloadSecureSettingsAction
extends BaseRestHandler {
    public RestReloadSecureSettingsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_nodes/reload_secure_settings", this);
        controller.registerHandler(RestRequest.Method.POST, "/_nodes/{nodeId}/reload_secure_settings", this);
    }

    @Override
    public String getName() {
        return "nodes_reload_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        NodesReloadSecureSettingsRequestBuilder nodesRequestBuilder = (NodesReloadSecureSettingsRequestBuilder)((NodesReloadSecureSettingsRequestBuilder)client.admin().cluster().prepareReloadSecureSettings().setTimeout(request.param("timeout"))).setNodesIds(nodesIds);
        NodesReloadSecureSettingsRequest nodesRequest = (NodesReloadSecureSettingsRequest)nodesRequestBuilder.request();
        return channel -> nodesRequestBuilder.execute(new RestBuilderListener<NodesReloadSecureSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesReloadSecureSettingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, this.channel.request());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

