/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestDeleteIndexTemplateAction
extends BaseRestHandler {
    public RestDeleteIndexTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.DELETE, "/_template/{name}", this);
    }

    @Override
    public String getName() {
        return "delete_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteIndexTemplateRequest deleteIndexTemplateRequest = new DeleteIndexTemplateRequest(request.param("name"));
        deleteIndexTemplateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteIndexTemplateRequest.masterNodeTimeout()));
        return channel -> client.admin().indices().deleteTemplate(deleteIndexTemplateRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

