/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.document;

import conductor.org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import conductor.org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import conductor.org.elasticsearch.action.termvectors.TermVectorsRequest;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import conductor.org.elasticsearch.rest.action.document.RestTermVectorsAction;
import java.io.IOException;

public class RestMultiTermVectorsAction
extends BaseRestHandler {
    public RestMultiTermVectorsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mtermvectors", this);
    }

    @Override
    public String getName() {
        return "document_multi_term_vectors_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiTermVectorsRequest multiTermVectorsRequest = new MultiTermVectorsRequest();
        TermVectorsRequest template = new TermVectorsRequest();
        template.index(request.param("index"));
        template.type(request.param("type"));
        RestTermVectorsAction.readURIParameters(template, request);
        multiTermVectorsRequest.ids(Strings.commaDelimitedListToStringArray(request.param("ids")));
        request.withContentOrSourceParamParserOrNull(p -> multiTermVectorsRequest.add(template, (XContentParser)p));
        return channel -> client.multiTermVectors(multiTermVectorsRequest, new RestToXContentListener<MultiTermVectorsResponse>((RestChannel)channel));
    }
}

