/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.document;

import conductor.org.elasticsearch.action.termvectors.TermVectorsRequest;
import conductor.org.elasticsearch.action.termvectors.TermVectorsResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestActions;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class RestTermVectorsAction
extends BaseRestHandler {
    public RestTermVectorsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_termvector", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_termvector", this);
    }

    @Override
    public String getName() {
        return "document_term_vectors_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        TermVectorsRequest termVectorsRequest = new TermVectorsRequest(request.param("index"), request.param("type"), request.param("id"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                TermVectorsRequest.parseRequest(termVectorsRequest, parser);
            }
        }
        RestTermVectorsAction.readURIParameters(termVectorsRequest, request);
        return channel -> client.termVectors(termVectorsRequest, new RestToXContentListener<TermVectorsResponse>((RestChannel)channel));
    }

    public static void readURIParameters(TermVectorsRequest termVectorsRequest, RestRequest request) {
        String fields = request.param("fields");
        RestTermVectorsAction.addFieldStringsFromParameter(termVectorsRequest, fields);
        termVectorsRequest.offsets(request.paramAsBoolean("offsets", termVectorsRequest.offsets()));
        termVectorsRequest.positions(request.paramAsBoolean("positions", termVectorsRequest.positions()));
        termVectorsRequest.payloads(request.paramAsBoolean("payloads", termVectorsRequest.payloads()));
        termVectorsRequest.routing(request.param("routing"));
        termVectorsRequest.realtime(request.paramAsBoolean("realtime", termVectorsRequest.realtime()));
        termVectorsRequest.version(RestActions.parseVersion(request, termVectorsRequest.version()));
        termVectorsRequest.versionType(VersionType.fromString(request.param("version_type"), termVectorsRequest.versionType()));
        termVectorsRequest.parent(request.param("parent"));
        termVectorsRequest.preference(request.param("preference"));
        termVectorsRequest.termStatistics(request.paramAsBoolean("termStatistics", termVectorsRequest.termStatistics()));
        termVectorsRequest.termStatistics(request.paramAsBoolean("term_statistics", termVectorsRequest.termStatistics()));
        termVectorsRequest.fieldStatistics(request.paramAsBoolean("fieldStatistics", termVectorsRequest.fieldStatistics()));
        termVectorsRequest.fieldStatistics(request.paramAsBoolean("field_statistics", termVectorsRequest.fieldStatistics()));
    }

    public static void addFieldStringsFromParameter(TermVectorsRequest termVectorsRequest, String fields) {
        Set<String> selectedFields = termVectorsRequest.selectedFields();
        if (fields != null) {
            String[] paramFieldStrings;
            for (String field : paramFieldStrings = Strings.commaDelimitedListToStringArray(fields)) {
                if (selectedFields == null) {
                    selectedFields = new HashSet<String>();
                }
                if (selectedFields.contains(field)) continue;
                field = field.replaceAll("\\s", "");
                selectedFields.add(field);
            }
        }
        if (selectedFields != null) {
            termVectorsRequest.selectedFields(selectedFields.toArray(new String[selectedFields.size()]));
        }
    }
}

