/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script.mustache;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.search.MultiSearchResponse;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.script.mustache.SearchTemplateResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class MultiSearchTemplateResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private Item[] items;

    MultiSearchTemplateResponse() {
    }

    public MultiSearchTemplateResponse(Item[] items) {
        this.items = items;
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] getResponses() {
        return this.items;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.items = new Item[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = Item.readItem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("responses");
        for (Item item : this.items) {
            if (item.isFailure()) {
                builder.startObject();
                ElasticsearchException.generateFailureXContent(builder, params, item.getFailure(), true);
                builder.endObject();
                continue;
            }
            item.getResponse().toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchTemplateResponse fromXContext(XContentParser parser) {
        MultiSearchResponse mSearchResponse = MultiSearchResponse.fromXContext(parser);
        MultiSearchResponse.Item[] responses = mSearchResponse.getResponses();
        Item[] templateResponses = new Item[responses.length];
        int i = 0;
        for (MultiSearchResponse.Item item : responses) {
            SearchTemplateResponse stResponse = null;
            if (item.getResponse() != null) {
                stResponse = new SearchTemplateResponse();
                stResponse.setResponse(item.getResponse());
            }
            templateResponses[i++] = new Item(stResponse, item.getFailure());
        }
        return new MultiSearchTemplateResponse(templateResponses);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static final class Fields {
        static final String RESPONSES = "responses";

        Fields() {
        }
    }

    public static class Item
    implements Streamable {
        private SearchTemplateResponse response;
        private Exception exception;

        Item() {
        }

        public Item(SearchTemplateResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchTemplateResponse getResponse() {
            return this.response;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchTemplateResponse();
                this.response.readFrom(in);
            } else {
                this.exception = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        public Exception getFailure() {
            return this.exception;
        }

        public String toString() {
            return "Item [response=" + this.response + ", exception=" + this.exception + "]";
        }
    }
}

