/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script.mustache;

import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import conductor.org.elasticsearch.rest.action.search.RestMultiSearchAction;
import conductor.org.elasticsearch.script.mustache.MultiSearchTemplateAction;
import conductor.org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class RestMultiSearchTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("typed_keys");
    private final boolean allowExplicitIndex;

    public RestMultiSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_msearch/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_msearch/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_msearch/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_msearch/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_msearch/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_msearch/template", this);
    }

    @Override
    public String getName() {
        return "multi_search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchTemplateRequest multiRequest = RestMultiSearchTemplateAction.parseRequest(request, this.allowExplicitIndex);
        return channel -> client.execute(MultiSearchTemplateAction.INSTANCE, multiRequest, new RestToXContentListener((RestChannel)channel));
    }

    public static MultiSearchTemplateRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        MultiSearchTemplateRequest multiRequest = new MultiSearchTemplateRequest();
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        RestMultiSearchAction.parseMultiLineRequest(restRequest, multiRequest.indicesOptions(), allowExplicitIndex, (searchRequest, bytes) -> {
            SearchTemplateRequest searchTemplateRequest = SearchTemplateRequest.fromXContent(bytes);
            if (searchTemplateRequest.getScript() == null) {
                throw new IllegalArgumentException("Malformed search template");
            }
            searchTemplateRequest.setRequest((SearchRequest)searchRequest);
            multiRequest.add(searchTemplateRequest);
        });
        return multiRequest;
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

