/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class InternalSingleBucketAggregation
extends InternalAggregation
implements SingleBucketAggregation {
    private long docCount;
    private InternalAggregations aggregations;

    protected InternalSingleBucketAggregation(String name, long docCount, InternalAggregations aggregations, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.docCount = docCount;
        this.aggregations = aggregations;
    }

    protected InternalSingleBucketAggregation(StreamInput in) throws IOException {
        super(in);
        this.docCount = in.readVLong();
        this.aggregations = InternalAggregations.readAggregations(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    public InternalSingleBucketAggregation create(InternalAggregations subAggregations) {
        return this.newAggregation(this.getName(), this.getDocCount(), subAggregations);
    }

    protected abstract InternalSingleBucketAggregation newAggregation(String var1, long var2, InternalAggregations var4);

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long docCount = 0L;
        ArrayList<InternalAggregations> subAggregationsList = new ArrayList<InternalAggregations>(aggregations.size());
        for (InternalAggregation aggregation : aggregations) {
            assert (aggregation.getName().equals(this.getName()));
            docCount += ((InternalSingleBucketAggregation)aggregation).docCount;
            subAggregationsList.add(((InternalSingleBucketAggregation)aggregation).aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(subAggregationsList, reduceContext);
        return this.newAggregation(this.getName(), docCount, aggs);
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        String aggName = path.get(0);
        if (aggName.equals("_count")) {
            if (path.size() > 1) {
                throw new IllegalArgumentException("_count must be the last element in the path");
            }
            return this.getDocCount();
        }
        InternalAggregation aggregation = (InternalAggregation)this.aggregations.get(aggName);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find an aggregation named [" + aggName + "] in [" + this.getName() + "]");
        }
        return aggregation.getProperty(path.subList(1, path.size()));
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        return builder;
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalSingleBucketAggregation other = (InternalSingleBucketAggregation)obj;
        return Objects.equals(this.docCount, other.docCount) && Objects.equals(this.aggregations, other.aggregations);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.docCount, this.aggregations);
    }
}

