/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.histogram;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.joda.Joda;
import conductor.org.elasticsearch.common.rounding.DateTimeUnit;
import conductor.org.elasticsearch.common.rounding.Rounding;
import conductor.org.elasticsearch.common.time.DateMathParser;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.BucketOrder;
import conductor.org.elasticsearch.search.aggregations.InternalOrder;
import conductor.org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import conductor.org.elasticsearch.search.aggregations.support.ValueType;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceType;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.joda.time.DateTimeField;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DateHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, DateHistogramAggregationBuilder>
implements MultiBucketAggregationBuilder {
    public static final String NAME = "date_histogram";
    private static DateMathParser EPOCH_MILLIS_PARSER = Joda.forPattern("epoch_millis", Locale.ROOT).toDateMathParser();
    public static final Map<String, DateTimeUnit> DATE_FIELD_UNITS;
    private static final ObjectParser<DateHistogramAggregationBuilder, Void> PARSER;
    private long interval;
    private DateHistogramInterval dateHistogramInterval;
    private long offset = 0L;
    private ExtendedBounds extendedBounds;
    private BucketOrder order = BucketOrder.key(true);
    private boolean keyed = false;
    private long minDocCount = 0L;

    public static DateHistogramAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new DateHistogramAggregationBuilder(aggregationName), null);
    }

    public DateHistogramAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.DATE);
    }

    protected DateHistogramAggregationBuilder(DateHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.interval = clone.interval;
        this.dateHistogramInterval = clone.dateHistogramInterval;
        this.offset = clone.offset;
        this.extendedBounds = clone.extendedBounds;
        this.order = clone.order;
        this.keyed = clone.keyed;
        this.minDocCount = clone.minDocCount;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new DateHistogramAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public DateHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.DATE);
        this.order = InternalOrder.Streams.readHistogramOrder(in, true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.interval = in.readLong();
        this.dateHistogramInterval = in.readOptionalWriteable(DateHistogramInterval::new);
        this.offset = in.readLong();
        this.extendedBounds = in.readOptionalWriteable(ExtendedBounds::new);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out, true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeLong(this.interval);
        out.writeOptionalWriteable(this.dateHistogramInterval);
        out.writeLong(this.offset);
        out.writeOptionalWriteable(this.extendedBounds);
    }

    public long interval() {
        return this.interval;
    }

    public DateHistogramAggregationBuilder interval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("[interval] must be 1 or greater for histogram aggregation [" + this.name + "]");
        }
        this.interval = interval;
        return this;
    }

    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval;
    }

    public DateHistogramAggregationBuilder dateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
        if (dateHistogramInterval == null) {
            throw new IllegalArgumentException("[dateHistogramInterval] must not be null: [" + this.name + "]");
        }
        this.dateHistogramInterval = dateHistogramInterval;
        return this;
    }

    public long offset() {
        return this.offset;
    }

    public DateHistogramAggregationBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public DateHistogramAggregationBuilder offset(String offset) {
        if (offset == null) {
            throw new IllegalArgumentException("[offset] must not be null: [" + this.name + "]");
        }
        return this.offset(DateHistogramAggregationBuilder.parseStringOffset(offset));
    }

    static long parseStringOffset(String offset) {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue(offset.substring(1), null, DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset").millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue(offset.substring(beginIndex), null, DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset").millis();
    }

    public ExtendedBounds extendedBounds() {
        return this.extendedBounds;
    }

    public DateHistogramAggregationBuilder extendedBounds(ExtendedBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extendedBounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public DateHistogramAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder(order) ? order : BucketOrder.compound(order);
        return this;
    }

    public DateHistogramAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public DateHistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public DateHistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dateHistogramInterval == null) {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        } else {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            this.extendedBounds.toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    DateTimeZone rewriteTimeZone(QueryShardContext context) throws IOException {
        DateTimeZone tz = this.timeZone();
        if (this.field() != null && tz != null && !tz.isFixed() && this.field() != null && this.script() == null) {
            MappedFieldType ft = context.fieldMapper(this.field());
            IndexReader reader = context.getIndexReader();
            if (ft != null && reader != null) {
                Long anyInstant = null;
                IndexNumericFieldData fieldData = (IndexNumericFieldData)context.getForField(ft);
                for (LeafReaderContext ctx : reader.leaves()) {
                    AtomicNumericFieldData leafFD = (AtomicNumericFieldData)fieldData.load(ctx);
                    SortedNumericDocValues values = leafFD.getLongValues();
                    if (values.nextDoc() == Integer.MAX_VALUE) continue;
                    anyInstant = values.nextValue();
                    break;
                }
                if (anyInstant != null) {
                    long low;
                    long prevTransition = tz.previousTransition(anyInstant);
                    long nextTransition = tz.nextTransition(anyInstant);
                    DateTimeUnit intervalAsUnit = this.getIntervalAsDateTimeUnit();
                    if (intervalAsUnit != null) {
                        DateTimeField dateTimeField = intervalAsUnit.field(tz);
                        low = dateTimeField.roundCeiling(prevTransition);
                    } else {
                        TimeValue intervalAsMillis = this.getIntervalAsTimeValue();
                        low = Math.addExact(prevTransition, intervalAsMillis.millis());
                    }
                    long high = nextTransition;
                    if (ft.isFieldWithinQuery(reader, low, high, true, false, DateTimeZone.UTC, EPOCH_MILLIS_PARSER, context) == MappedFieldType.Relation.WITHIN) {
                        return DateTimeZone.forOffsetMillis(tz.getOffset(anyInstant));
                    }
                }
            }
        }
        return tz;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        DateTimeZone tz = this.timeZone();
        Rounding rounding = this.createRounding(tz);
        DateTimeZone rewrittenTimeZone = this.rewriteTimeZone(context.getQueryShardContext());
        Rounding shardRounding = tz == rewrittenTimeZone ? rounding : this.createRounding(rewrittenTimeZone);
        ExtendedBounds roundedBounds = null;
        if (this.extendedBounds != null) {
            roundedBounds = this.extendedBounds.parseAndValidate(this.name, context, config.format()).round(rounding);
        }
        return new DateHistogramAggregatorFactory(this.name, config, this.offset, this.order, this.keyed, this.minDocCount, rounding, shardRounding, roundedBounds, context, parent, subFactoriesBuilder, this.metaData);
    }

    private DateTimeUnit getIntervalAsDateTimeUnit() {
        if (this.dateHistogramInterval != null) {
            return DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString());
        }
        return null;
    }

    private TimeValue getIntervalAsTimeValue() {
        if (this.dateHistogramInterval != null) {
            return TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), null, this.getClass().getSimpleName() + ".interval");
        }
        return TimeValue.timeValueMillis(this.interval);
    }

    private Rounding createRounding(DateTimeZone timeZone) {
        DateTimeUnit intervalAsUnit = this.getIntervalAsDateTimeUnit();
        Rounding.Builder tzRoundingBuilder = intervalAsUnit != null ? Rounding.builder(intervalAsUnit) : Rounding.builder(this.getIntervalAsTimeValue());
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        Rounding rounding = tzRoundingBuilder.build();
        return rounding;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.order, this.keyed, this.minDocCount, this.interval, this.dateHistogramInterval, this.minDocCount, this.extendedBounds);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        DateHistogramAggregationBuilder other = (DateHistogramAggregationBuilder)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.interval, other.interval) && Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds);
    }

    static {
        HashMap<String, DateTimeUnit> dateFieldUnits = new HashMap<String, DateTimeUnit>();
        dateFieldUnits.put("year", DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("1y", DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("quarter", DateTimeUnit.QUARTER);
        dateFieldUnits.put("1q", DateTimeUnit.QUARTER);
        dateFieldUnits.put("month", DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("1M", DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("week", DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("1w", DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("day", DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("1d", DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("hour", DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("1h", DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("minute", DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("1m", DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("second", DateTimeUnit.SECOND_OF_MINUTE);
        dateFieldUnits.put("1s", DateTimeUnit.SECOND_OF_MINUTE);
        DATE_FIELD_UNITS = Collections.unmodifiableMap(dateFieldUnits);
        PARSER = new ObjectParser(NAME);
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, true);
        PARSER.declareField((histogram, interval) -> {
            if (interval instanceof Long) {
                histogram.interval((Long)interval);
            } else {
                histogram.dateHistogramInterval((DateHistogramInterval)interval);
            }
        }, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return new DateHistogramInterval(p.text());
        }, Histogram.INTERVAL_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareField(DateHistogramAggregationBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return DateHistogramAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareBoolean(DateHistogramAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(DateHistogramAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField(DateHistogramAggregationBuilder::extendedBounds, parser -> ExtendedBounds.PARSER.apply((XContentParser)parser, (Void)null), ExtendedBounds.EXTENDED_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(DateHistogramAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam(p), Histogram.ORDER_FIELD);
    }
}

