/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.scripted;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.elasticsearch.common.util.CollectionUtils;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.script.ScriptedMetricAggContexts;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import conductor.org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ScriptedMetricAggregator
extends MetricsAggregator {
    private final ScriptedMetricAggContexts.MapScript.LeafFactory mapScript;
    private final ScriptedMetricAggContexts.CombineScript combineScript;
    private final Script reduceScript;
    private Object aggState;

    protected ScriptedMetricAggregator(String name, ScriptedMetricAggContexts.MapScript.LeafFactory mapScript, ScriptedMetricAggContexts.CombineScript combineScript, Script reduceScript, Object aggState, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.aggState = aggState;
        this.mapScript = mapScript;
        this.combineScript = combineScript;
        this.reduceScript = reduceScript;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final ScriptedMetricAggContexts.MapScript leafMapScript = this.mapScript.newInstance(ctx);
        return new LeafBucketCollectorBase(sub, leafMapScript){

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                leafMapScript.setScorer(scorer);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L) : bucket;
                leafMapScript.setDocument(doc);
                leafMapScript.execute();
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        Object aggregation;
        if (this.combineScript != null) {
            aggregation = this.combineScript.execute();
            CollectionUtils.ensureNoSelfReferences(aggregation);
        } else {
            aggregation = this.aggState;
        }
        return new InternalScriptedMetric(this.name, aggregation, this.reduceScript, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalScriptedMetric(this.name, (Object)null, this.reduceScript, this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected void doPostCollection() throws IOException {
        CollectionUtils.ensureNoSelfReferences(this.aggState);
        super.doPostCollection();
    }
}

