/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.valuecount;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalValueCount
extends InternalNumericMetricsAggregation.SingleValue
implements ValueCount {
    private final long value;

    public InternalValueCount(String name, long value, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.value = value;
    }

    public InternalValueCount(StreamInput in) throws IOException {
        super(in);
        this.value = in.readVLong();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.value);
    }

    @Override
    public String getWriteableName() {
        return "value_count";
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long valueCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            valueCount += ((InternalValueCount)aggregation).value;
        }
        return new InternalValueCount(this.name, valueCount, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value);
        return builder;
    }

    @Override
    public String toString() {
        return "count[" + this.value + "]";
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.value);
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalValueCount that = (InternalValueCount)obj;
        return Objects.equals(this.value, that.value);
    }
}

