/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline;

import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import conductor.org.elasticsearch.search.aggregations.pipeline.SimpleValue;
import java.io.IOException;

public class ParsedSimpleValue
extends ParsedSingleValueNumericMetricsAggregation
implements SimpleValue {
    private static final ObjectParser<ParsedSimpleValue, Void> PARSER = new ObjectParser(ParsedSimpleValue.class.getSimpleName(), true, ParsedSimpleValue::new);

    @Override
    public String getType() {
        return "simple_value";
    }

    public static ParsedSimpleValue fromXContent(XContentParser parser, String name) {
        ParsedSimpleValue simpleValue = PARSER.apply(parser, null);
        simpleValue.setName(name);
        return simpleValue;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isNaN(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    static {
        ParsedSimpleValue.declareSingleValueFields(PARSER, Double.NaN);
    }
}

