/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.movavg.models;

import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.NamedWriteable;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public abstract class MovAvgModel
implements NamedWriteable,
ToXContentFragment {
    public boolean minimizeByDefault() {
        return false;
    }

    public abstract boolean canBeMinimized();

    public abstract MovAvgModel neighboringModel();

    public boolean hasValue(int valuesAvailable) {
        return valuesAvailable > 0;
    }

    public abstract double next(Collection<Double> var1);

    public double[] predict(Collection<Double> values, int numPredictions) {
        assert (numPredictions >= 1);
        if (values.isEmpty()) {
            return this.emptyPredictions(numPredictions);
        }
        return this.doPredict(values, numPredictions);
    }

    protected abstract double[] doPredict(Collection<Double> var1, int var2);

    protected double[] emptyPredictions(int numPredictions) {
        double[] predictions = new double[numPredictions];
        Arrays.fill(predictions, Double.NaN);
        return predictions;
    }

    @Override
    public abstract void writeTo(StreamOutput var1) throws IOException;

    public abstract MovAvgModel clone();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static abstract class AbstractModelParser {
        public abstract MovAvgModel parse(@Nullable Map<String, Object> var1, String var2, int var3) throws ParseException;

        protected double parseDoubleParam(@Nullable Map<String, Object> settings, String name, double defaultValue) throws ParseException {
            if (settings == null) {
                return defaultValue;
            }
            Object value = settings.get(name);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Number) {
                double v = ((Number)value).doubleValue();
                if (v >= 0.0 && v <= 1.0) {
                    settings.remove(name);
                    return v;
                }
                throw new ParseException("Parameter [" + name + "] must be between 0-1 inclusive.  Providedvalue was [" + v + "]", 0);
            }
            throw new ParseException("Parameter [" + name + "] must be a double, type `" + value.getClass().getSimpleName() + "` provided instead", 0);
        }

        protected int parseIntegerParam(@Nullable Map<String, Object> settings, String name, int defaultValue) throws ParseException {
            if (settings == null) {
                return defaultValue;
            }
            Object value = settings.get(name);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Number) {
                settings.remove(name);
                return ((Number)value).intValue();
            }
            throw new ParseException("Parameter [" + name + "] must be an integer, type `" + value.getClass().getSimpleName() + "` provided instead", 0);
        }

        protected boolean parseBoolParam(@Nullable Map<String, Object> settings, String name, boolean defaultValue) throws ParseException {
            if (settings == null) {
                return defaultValue;
            }
            Object value = settings.get(name);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Boolean) {
                settings.remove(name);
                return (Boolean)value;
            }
            throw new ParseException("Parameter [" + name + "] must be a boolean, type `" + value.getClass().getSimpleName() + "` provided instead", 0);
        }

        protected void checkUnrecognizedParams(@Nullable Map<String, Object> settings) throws ParseException {
            if (settings != null && settings.size() > 0) {
                throw new ParseException("Unrecognized parameter(s): [" + settings.keySet() + "]", 0);
            }
        }
    }
}

