/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchShardTarget;
import conductor.org.elasticsearch.search.fetch.FetchSearchResult;
import conductor.org.elasticsearch.search.fetch.QueryFetchSearchResult;
import conductor.org.elasticsearch.search.query.QuerySearchResult;
import java.io.IOException;

public final class ScrollQueryFetchSearchResult
extends SearchPhaseResult {
    private QueryFetchSearchResult result;

    public ScrollQueryFetchSearchResult() {
    }

    public ScrollQueryFetchSearchResult(QueryFetchSearchResult result, SearchShardTarget shardTarget) {
        this.result = result;
        this.setSearchShardTarget(shardTarget);
    }

    public QueryFetchSearchResult result() {
        return this.result;
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.result.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int shardIndex) {
        super.setShardIndex(shardIndex);
        this.result.setShardIndex(shardIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.result.queryResult();
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.result.fetchResult();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        SearchShardTarget searchShardTarget = new SearchShardTarget(in);
        this.result = QueryFetchSearchResult.readQueryFetchSearchResult(in);
        this.setSearchShardTarget(searchShardTarget);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.getSearchShardTarget().writeTo(out);
        this.result.writeTo(out);
    }
}

