/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.profile.aggregation;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.profile.Timer;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationTimingType;
import conductor.org.elasticsearch.search.profile.aggregation.ProfilingLeafBucketCollector;
import java.io.IOException;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) throws IOException {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean needsScores() {
        return this.delegate.needsScores();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public SearchContext context() {
        return this.delegate.context();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        InternalAggregation result;
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_AGGREGATION);
        timer.start();
        try {
            result = this.delegate.buildAggregation(bucket);
        }
        finally {
            timer.stop();
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        return new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(ctx), this.profileBreakdown);
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.INITIALIZE);
        timer.start();
        try {
            this.delegate.preCollection();
        }
        finally {
            timer.stop();
        }
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        this.delegate.postCollection();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static Aggregator unwrap(Aggregator agg) {
        if (agg instanceof ProfilingAggregator) {
            return ((ProfilingAggregator)agg).delegate;
        }
        return agg;
    }
}

