/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch;

import com.google.inject.ProvisionException;
import com.netflix.conductor.elasticsearch.ElasticSearchConfiguration;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.transport.client.PreBuiltTransportClient;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchTransportClientProvider
implements Provider<Client> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchTransportClientProvider.class);
    private final ElasticSearchConfiguration configuration;

    @Inject
    public ElasticSearchTransportClientProvider(ElasticSearchConfiguration configuration) {
        this.configuration = configuration;
    }

    public Client get() {
        Settings settings = Settings.builder().put("client.transport.ignore_cluster_name", true).put("client.transport.sniff", true).build();
        PreBuiltTransportClient tc = new PreBuiltTransportClient(settings, new Class[0]);
        List<URI> clusterAddresses = this.configuration.getURIs();
        if (clusterAddresses.isEmpty()) {
            logger.warn("workflow.elasticsearch.url is not set.  Indexing will remain DISABLED.");
        }
        for (URI hostAddress : clusterAddresses) {
            int port = Optional.ofNullable(hostAddress.getPort()).orElse(9200);
            try {
                tc.addTransportAddress(new TransportAddress(InetAddress.getByName(hostAddress.getHost()), port));
            }
            catch (Exception e) {
                throw new ProvisionException("Invalid host" + hostAddress.getHost(), (Throwable)e);
            }
        }
        return tc;
    }
}

