/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.core;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.core.TypeTokenFilter;
import conductor.org.apache.lucene.analysis.util.ResourceLoader;
import conductor.org.apache.lucene.analysis.util.ResourceLoaderAware;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private final boolean useWhitelist;
    private final String stopTypesFiles;
    private Set<String> stopTypes;

    public TypeTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.stopTypesFiles = this.require(args, "types");
        this.useWhitelist = this.getBoolean(args, "useWhitelist", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        List<String> files = this.splitFileNames(this.stopTypesFiles);
        if (files.size() > 0) {
            this.stopTypes = new HashSet<String>();
            for (String file : files) {
                List<String> typesLines = this.getLines(loader, file.trim());
                this.stopTypes.addAll(typesLines);
            }
        }
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        TypeTokenFilter filter = new TypeTokenFilter(input, this.stopTypes, this.useWhitelist);
        return filter;
    }
}

