/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.cz;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.LowerCaseFilter;
import conductor.org.apache.lucene.analysis.StopFilter;
import conductor.org.apache.lucene.analysis.StopwordAnalyzerBase;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.WordlistLoader;
import conductor.org.apache.lucene.analysis.cz.CzechStemFilter;
import conductor.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import conductor.org.apache.lucene.analysis.standard.StandardTokenizer;
import conductor.org.apache.lucene.util.IOUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class CzechAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final CharArraySet stemExclusionTable;

    public static final CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public CzechAnalyzer() {
        this(DefaultSetHolder.DEFAULT_SET);
    }

    public CzechAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public CzechAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable) {
        super(stopwords);
        this.stemExclusionTable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionTable));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionTable.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionTable);
        }
        result = new CzechStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        private static final CharArraySet DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = WordlistLoader.getWordSet(IOUtils.getDecodingReader(CzechAnalyzer.class, CzechAnalyzer.DEFAULT_STOPWORD_FILE, StandardCharsets.UTF_8), "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

