/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.no;

import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.no.NorwegianMinimalStemmer;
import conductor.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class NorwegianMinimalStemFilter
extends TokenFilter {
    private final NorwegianMinimalStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public NorwegianMinimalStemFilter(TokenStream input) {
        this(input, 1);
    }

    public NorwegianMinimalStemFilter(TokenStream input, int flags) {
        super(input);
        this.stemmer = new NorwegianMinimalStemmer(flags);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

