/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.payloads;

import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.payloads.PayloadEncoder;
import conductor.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import java.io.IOException;

public final class DelimitedPayloadTokenFilter
extends TokenFilter {
    public static final char DEFAULT_DELIMITER = '|';
    private final char delimiter;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PayloadAttribute payAtt = this.addAttribute(PayloadAttribute.class);
    private final PayloadEncoder encoder;

    public DelimitedPayloadTokenFilter(TokenStream input, char delimiter, PayloadEncoder encoder) {
        super(input);
        this.delimiter = delimiter;
        this.encoder = encoder;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != this.delimiter) continue;
                this.payAtt.setPayload(this.encoder.encode(buffer, i + 1, length - (i + 1)));
                this.termAtt.setLength(i);
                return true;
            }
            this.payAtt.setPayload(null);
            return true;
        }
        return false;
    }
}

