/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.codecs;

import conductor.org.apache.lucene.codecs.FieldsProducer;
import conductor.org.apache.lucene.index.Fields;
import conductor.org.apache.lucene.index.MappedMultiFields;
import conductor.org.apache.lucene.index.MergeState;
import conductor.org.apache.lucene.index.MultiFields;
import conductor.org.apache.lucene.index.ReaderSlice;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;

public abstract class FieldsConsumer
implements Closeable {
    protected FieldsConsumer() {
    }

    public abstract void write(Fields var1) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        ArrayList<FieldsProducer> fields = new ArrayList<FieldsProducer>();
        ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
        int docBase = 0;
        for (int readerIndex = 0; readerIndex < mergeState.fieldsProducers.length; ++readerIndex) {
            FieldsProducer f = mergeState.fieldsProducers[readerIndex];
            int maxDoc = mergeState.maxDocs[readerIndex];
            f.checkIntegrity();
            slices.add(new ReaderSlice(docBase, maxDoc, readerIndex));
            fields.add(f);
            docBase += maxDoc;
        }
        MappedMultiFields mergedFields = new MappedMultiFields(mergeState, new MultiFields(fields.toArray(Fields.EMPTY_ARRAY), slices.toArray(ReaderSlice.EMPTY_ARRAY)));
        this.write(mergedFields);
    }

    @Override
    public abstract void close() throws IOException;
}

