/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.geo;

import conductor.org.apache.lucene.geo.GeoUtils;
import conductor.org.apache.lucene.geo.Polygon;
import conductor.org.apache.lucene.util.SloppyMath;

public class Rectangle {
    public final double minLat;
    public final double minLon;
    public final double maxLat;
    public final double maxLon;
    public static final double AXISLAT_ERROR = 8.993203677616636E-7;

    public Rectangle(double minLat, double maxLat, double minLon, double maxLon) {
        GeoUtils.checkLatitude(minLat);
        GeoUtils.checkLatitude(maxLat);
        GeoUtils.checkLongitude(minLon);
        GeoUtils.checkLongitude(maxLon);
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
        assert (maxLat >= minLat);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Rectangle(lat=");
        b.append(this.minLat);
        b.append(" TO ");
        b.append(this.maxLat);
        b.append(" lon=");
        b.append(this.minLon);
        b.append(" TO ");
        b.append(this.maxLon);
        if (this.maxLon < this.minLon) {
            b.append(" [crosses dateline!]");
        }
        b.append(")");
        return b.toString();
    }

    public boolean crossesDateline() {
        return this.maxLon < this.minLon;
    }

    public static Rectangle fromPointDistance(double centerLat, double centerLon, double radiusMeters) {
        double maxLon;
        double minLon;
        GeoUtils.checkLatitude(centerLat);
        GeoUtils.checkLongitude(centerLon);
        double radLat = SloppyMath.toRadians(centerLat);
        double radLon = SloppyMath.toRadians(centerLon);
        double radDistance = (radiusMeters + 0.07) / 6371008.7714;
        double minLat = radLat - radDistance;
        double maxLat = radLat + radDistance;
        if (minLat > -1.5707963267948966 && maxLat < 1.5707963267948966) {
            double deltaLon = SloppyMath.asin(GeoUtils.sloppySin(radDistance) / SloppyMath.cos(radLat));
            minLon = radLon - deltaLon;
            if (minLon < -Math.PI) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > Math.PI) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, -1.5707963267948966);
            maxLat = Math.min(maxLat, 1.5707963267948966);
            minLon = -Math.PI;
            maxLon = Math.PI;
        }
        return new Rectangle(SloppyMath.toDegrees(minLat), SloppyMath.toDegrees(maxLat), SloppyMath.toDegrees(minLon), SloppyMath.toDegrees(maxLon));
    }

    public static double axisLat(double centerLat, double radiusMeters) {
        double PIO2 = 1.5707963267948966;
        double l1 = SloppyMath.toRadians(centerLat);
        double r = (radiusMeters + 0.07) / 6371008.7714;
        if (Math.abs(l1) + r >= 1.5707963267948966) {
            return centerLat >= 0.0 ? 90.0 : -90.0;
        }
        l1 = centerLat >= 0.0 ? 1.5707963267948966 - l1 : l1 + 1.5707963267948966;
        double l2 = Math.acos(Math.cos(l1) / Math.cos(r));
        assert (!Double.isNaN(l2));
        l2 = centerLat >= 0.0 ? 1.5707963267948966 - l2 : l2 - 1.5707963267948966;
        return SloppyMath.toDegrees(l2);
    }

    public static Rectangle fromPolygon(Polygon[] polygons) {
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < polygons.length; ++i) {
            minLat = Math.min(polygons[i].minLat, minLat);
            maxLat = Math.max(polygons[i].maxLat, maxLat);
            minLon = Math.min(polygons[i].minLon, minLon);
            maxLon = Math.max(polygons[i].maxLon, maxLon);
        }
        return new Rectangle(minLat, maxLat, minLon, maxLon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        if (Double.compare(rectangle.minLat, this.minLat) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minLon, this.minLon) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxLat, this.maxLat) != 0) {
            return false;
        }
        return Double.compare(rectangle.maxLon, this.maxLon) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minLat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

