/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import conductor.org.apache.lucene.index.BufferedUpdates;
import conductor.org.apache.lucene.index.BufferedUpdatesStream;
import conductor.org.apache.lucene.index.DocValuesFieldUpdates;
import conductor.org.apache.lucene.index.DocValuesUpdate;
import conductor.org.apache.lucene.index.FieldTermIterator;
import conductor.org.apache.lucene.index.IndexWriter;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValuesFieldUpdates;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.PrefixCodedTerms;
import conductor.org.apache.lucene.index.SegmentCommitInfo;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.store.ByteArrayDataInput;
import conductor.org.apache.lucene.store.RAMOutputStream;
import conductor.org.apache.lucene.util.ArrayUtil;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.Counter;
import conductor.org.apache.lucene.util.IOUtils;
import conductor.org.apache.lucene.util.InfoStream;
import conductor.org.apache.lucene.util.RamUsageEstimator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;

final class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms deleteTerms;
    final Query[] deleteQueries;
    final int[] deleteQueryLimits;
    final byte[] numericDVUpdates;
    final byte[] binaryDVUpdates;
    private final int numericDVUpdateCount;
    private final int binaryDVUpdateCount;
    public final CountDownLatch applied = new CountDownLatch(1);
    public long totalDelCount;
    final int bytesUsed;
    final int numTermDeletes;
    private long delGen = -1L;
    final SegmentCommitInfo privateSegment;
    private final InfoStream infoStream;

    public FrozenBufferedUpdates(InfoStream infoStream, BufferedUpdates updates, SegmentCommitInfo privateSegment) throws IOException {
        this.infoStream = infoStream;
        this.privateSegment = privateSegment;
        assert (updates.deleteDocIDs.isEmpty());
        assert (privateSegment == null || updates.deleteTerms.isEmpty()) : "segment private packet should only have del queries";
        Comparable[] termsArray = updates.deleteTerms.keySet().toArray(new Term[updates.deleteTerms.size()]);
        ArrayUtil.timSort((Comparable[])termsArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable term : termsArray) {
            builder.add((Term)term);
        }
        this.deleteTerms = builder.finish();
        this.deleteQueries = new Query[updates.deleteQueries.size()];
        this.deleteQueryLimits = new int[updates.deleteQueries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : updates.deleteQueries.entrySet()) {
            this.deleteQueries[upto] = ent.getKey();
            this.deleteQueryLimits[upto] = ent.getValue();
            ++upto;
        }
        Counter counter = Counter.newCounter();
        this.numericDVUpdates = FrozenBufferedUpdates.freezeDVUpdates(updates.numericUpdates, counter::addAndGet);
        this.numericDVUpdateCount = (int)counter.get();
        counter.addAndGet(-counter.get());
        assert (counter.get() == 0L);
        this.binaryDVUpdates = FrozenBufferedUpdates.freezeDVUpdates(updates.binaryUpdates, counter::addAndGet);
        this.binaryDVUpdateCount = (int)counter.get();
        this.bytesUsed = (int)(this.deleteTerms.ramBytesUsed() + (long)(this.deleteQueries.length * BYTES_PER_DEL_QUERY) + (long)this.numericDVUpdates.length + (long)this.binaryDVUpdates.length);
        this.numTermDeletes = updates.numTermDeletes.get();
        if (infoStream != null && infoStream.isEnabled("BD")) {
            infoStream.message("BD", String.format(Locale.ROOT, "compressed %d to %d bytes (%.2f%%) for deletes/updates; private segment %s", updates.bytesUsed.get(), this.bytesUsed, 100.0 * (double)this.bytesUsed / (double)updates.bytesUsed.get(), privateSegment));
        }
    }

    private static <T extends DocValuesUpdate> byte[] freezeDVUpdates(Map<String, LinkedHashMap<Term, T>> dvUpdates, IntConsumer updateSizeConsumer) throws IOException {
        try (RAMOutputStream out = new RAMOutputStream();){
            String lastTermField = null;
            String lastUpdateField = null;
            for (LinkedHashMap<Term, T> updates : dvUpdates.values()) {
                updateSizeConsumer.accept(updates.size());
                for (DocValuesUpdate update : updates.values()) {
                    String updateField;
                    int code = update.term.bytes().length << 3;
                    String termField = update.term.field();
                    if (!termField.equals(lastTermField)) {
                        code |= 1;
                    }
                    if (!(updateField = update.field).equals(lastUpdateField)) {
                        code |= 2;
                    }
                    if (update.hasValue()) {
                        code |= 4;
                    }
                    out.writeVInt(code);
                    out.writeVInt(update.docIDUpto);
                    if (!termField.equals(lastTermField)) {
                        out.writeString(termField);
                        lastTermField = termField;
                    }
                    if (!updateField.equals(lastUpdateField)) {
                        out.writeString(updateField);
                        lastUpdateField = updateField;
                    }
                    out.writeBytes(update.term.bytes().bytes, update.term.bytes().offset, update.term.bytes().length);
                    if (!update.hasValue()) continue;
                    update.writeTo(out);
                }
            }
            byte[] bytes = new byte[(int)out.getFilePointer()];
            out.writeTo(bytes, 0);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    private List<SegmentCommitInfo> getInfosToApply(IndexWriter writer) {
        List<SegmentCommitInfo> infos;
        assert (Thread.holdsLock(writer));
        if (this.privateSegment != null) {
            if (writer.segmentCommitInfoExist(this.privateSegment)) {
                infos = Collections.singletonList(this.privateSegment);
            } else {
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "private segment already gone; skip processing updates");
                }
                infos = null;
            }
        } else {
            infos = writer.listOfSegmentCommitInfos();
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void apply(IndexWriter writer) throws IOException {
        if (this.applied.getCount() == 0L) {
            return;
        }
        long startNS = System.nanoTime();
        assert (this.any());
        HashSet<SegmentCommitInfo> seenSegments = new HashSet<SegmentCommitInfo>();
        int iter = 0;
        int totalSegmentCount = 0;
        long totalDelCount = 0L;
        boolean finished = false;
        while (true) {
            long delCount;
            BufferedUpdatesStream.SegmentState[] segStates;
            String messagePrefix = iter == 0 ? "" : "iter " + iter;
            long iterStartNS = System.nanoTime();
            long mergeGenStart = writer.mergeFinishedGen.get();
            HashSet<String> delFiles = new HashSet<String>();
            IndexWriter indexWriter = writer;
            synchronized (indexWriter) {
                List<SegmentCommitInfo> infos = this.getInfosToApply(writer);
                if (infos == null) {
                    break;
                }
                for (SegmentCommitInfo info : infos) {
                    delFiles.addAll(info.files());
                }
                segStates = FrozenBufferedUpdates.openSegmentStates(writer, infos, seenSegments, this.delGen());
                if (segStates.length == 0) {
                    if (this.infoStream.isEnabled("BD")) {
                        this.infoStream.message("BD", "packet matches no segments");
                    }
                    break;
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "now apply del packet (%s) to %d segments, mergeGen %d", this, segStates.length, mergeGenStart));
                }
                totalSegmentCount += segStates.length;
                writer.deleter.incRef(delFiles);
            }
            AtomicBoolean success = new AtomicBoolean();
            try (Closeable finalizer = () -> this.finishApply(writer, segStates, success.get(), delFiles);){
                delCount = this.apply(segStates);
                success.set(true);
            }
            writer.writeSomeDocValuesUpdates();
            totalDelCount += delCount;
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "done inner apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, segStates.length, delCount, (double)(System.nanoTime() - iterStartNS) / 1.0E9));
            }
            if (this.privateSegment != null) break;
            IndexWriter indexWriter2 = writer;
            synchronized (indexWriter2) {
                long mergeGenCur = writer.mergeFinishedGen.get();
                if (mergeGenCur == mergeGenStart) {
                    writer.finished(this);
                    finished = true;
                    break;
                }
            }
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", messagePrefix + "concurrent merges finished; move to next iter");
            }
            ++iter;
        }
        if (!finished) {
            writer.finished(this);
        }
        if (this.infoStream.isEnabled("BD")) {
            String message = String.format(Locale.ROOT, "done apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, totalSegmentCount, totalDelCount, (double)(System.nanoTime() - startNS) / 1.0E9);
            if (iter > 0) {
                message = message + "; " + (iter + 1) + " iters due to concurrent merges";
            }
            message = message + "; " + writer.getPendingUpdatesCount() + " packets remain";
            this.infoStream.message("BD", message);
        }
    }

    private static BufferedUpdatesStream.SegmentState[] openSegmentStates(IndexWriter writer, List<SegmentCommitInfo> infos, Set<SegmentCommitInfo> alreadySeenSegments, long delGen) throws IOException {
        ArrayList<BufferedUpdatesStream.SegmentState> segStates = new ArrayList<BufferedUpdatesStream.SegmentState>();
        try {
            for (SegmentCommitInfo info : infos) {
                if (info.getBufferedDeletesGen() > delGen || alreadySeenSegments.contains(info)) continue;
                segStates.add(new BufferedUpdatesStream.SegmentState(writer.getPooledInstance(info, true), writer::release, info));
                alreadySeenSegments.add(info);
            }
        }
        catch (Throwable t) {
            try {
                IOUtils.close(segStates);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
        return segStates.toArray(new BufferedUpdatesStream.SegmentState[0]);
    }

    public static BufferedUpdatesStream.ApplyDeletesResult closeSegmentStates(IndexWriter writer, BufferedUpdatesStream.SegmentState[] segStates, boolean success) throws IOException {
        ArrayList<SegmentCommitInfo> allDeleted = null;
        long totDelCount = 0L;
        List<BufferedUpdatesStream.SegmentState> segmentStates = Arrays.asList(segStates);
        for (BufferedUpdatesStream.SegmentState segState : segmentStates) {
            if (!success) continue;
            totDelCount += (long)(segState.rld.getDelCount() - segState.startDelCount);
            int fullDelCount = segState.rld.getDelCount();
            assert (fullDelCount <= segState.rld.info.info.maxDoc()) : fullDelCount + " > " + segState.rld.info.info.maxDoc();
            if (!segState.rld.isFullyDeleted() || writer.getConfig().getMergePolicy().keepFullyDeletedSegment(() -> segState.reader)) continue;
            if (allDeleted == null) {
                allDeleted = new ArrayList<SegmentCommitInfo>();
            }
            allDeleted.add(segState.reader.getOriginalSegmentInfo());
        }
        IOUtils.close(segmentStates);
        if (writer.infoStream.isEnabled("BD")) {
            writer.infoStream.message("BD", "closeSegmentStates: " + totDelCount + " new deleted documents; pool " + writer.getPendingUpdatesCount() + " packets; bytesUsed=" + writer.getReaderPoolRamBytesUsed());
        }
        return new BufferedUpdatesStream.ApplyDeletesResult(totDelCount > 0L, allDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishApply(IndexWriter writer, BufferedUpdatesStream.SegmentState[] segStates, boolean success, Set<String> delFiles) throws IOException {
        IndexWriter indexWriter = writer;
        synchronized (indexWriter) {
            BufferedUpdatesStream.ApplyDeletesResult result;
            try {
                result = FrozenBufferedUpdates.closeSegmentStates(writer, segStates, success);
            }
            finally {
                writer.deleter.decRef(delFiles);
            }
            if (result.anyDeletes) {
                writer.maybeMerge.set(true);
                writer.checkpoint();
            }
            if (result.allDeleted != null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "drop 100% deleted segments: " + writer.segString(result.allDeleted));
                }
                for (SegmentCommitInfo info : result.allDeleted) {
                    writer.dropDeletedSegment(info);
                }
                writer.checkpoint();
            }
        }
    }

    private synchronized long apply(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.delGen == -1L) {
            throw new IllegalArgumentException("gen is not yet set; call BufferedUpdatesStream.push first");
        }
        assert (this.applied.getCount() != 0L);
        if (this.privateSegment != null) {
            assert (segStates.length == 1);
            assert (this.privateSegment == segStates[0].reader.getOriginalSegmentInfo());
        }
        this.totalDelCount += this.applyTermDeletes(segStates);
        this.totalDelCount += this.applyQueryDeletes(segStates);
        this.totalDelCount += this.applyDocValuesUpdates(segStates);
        return this.totalDelCount;
    }

    private long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.numericDVUpdates.length == 0 && this.binaryDVUpdates.length == 0) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long updateCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            boolean isSegmentPrivateDeletes;
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            boolean bl = isSegmentPrivateDeletes = this.privateSegment != null;
            if (this.numericDVUpdates.length > 0) {
                updateCount += FrozenBufferedUpdates.applyDocValuesUpdates(segState, this.numericDVUpdates, true, this.delGen, isSegmentPrivateDeletes);
            }
            if (this.binaryDVUpdates.length <= 0) continue;
            updateCount += FrozenBufferedUpdates.applyDocValuesUpdates(segState, this.binaryDVUpdates, false, this.delGen, isSegmentPrivateDeletes);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyDocValuesUpdates %.1f msec for %d segments, %d numeric updates and %d binary updates; %d new updates", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.numericDVUpdateCount, this.binaryDVUpdateCount, updateCount));
        }
        return updateCount;
    }

    private static long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState segState, byte[] updates, boolean isNumeric, long delGen, boolean segmentPrivateDeletes) throws IOException {
        TermsEnum termsEnum = null;
        PostingsEnum postingsEnum = null;
        long updateCount = 0L;
        HashMap<String, DocValuesFieldUpdates> holder = new HashMap<String, DocValuesFieldUpdates>();
        ByteArrayDataInput in = new ByteArrayDataInput(updates);
        String termField = null;
        String updateField = null;
        BytesRef term = new BytesRef();
        term.bytes = new byte[16];
        BytesRef scratch = new BytesRef();
        scratch.bytes = new byte[16];
        while (in.getPosition() != updates.length) {
            int doc2;
            BytesRef binaryValue;
            long longValue;
            int limit;
            boolean hasValue;
            int code = in.readVInt();
            int docIDUpto = in.readVInt();
            term.length = code >> 3;
            if ((code & 1) != 0) {
                termField = in.readString();
            }
            if ((code & 2) != 0) {
                updateField = in.readString();
            }
            boolean bl = hasValue = (code & 4) != 0;
            if (term.bytes.length < term.length) {
                term.bytes = ArrayUtil.grow(term.bytes, term.length);
            }
            in.readBytes(term.bytes, 0, term.length);
            if (delGen == segState.delGen) {
                assert (segmentPrivateDeletes);
                limit = docIDUpto;
            } else {
                limit = Integer.MAX_VALUE;
            }
            if ((code & 1) != 0) {
                Terms terms = segState.reader.terms(termField);
                termsEnum = terms != null ? terms.iterator() : null;
            }
            if (!hasValue) {
                longValue = -1L;
                binaryValue = null;
            } else if (isNumeric) {
                longValue = DocValuesUpdate.NumericDocValuesUpdate.readFrom(in);
                binaryValue = null;
            } else {
                longValue = -1L;
                binaryValue = DocValuesUpdate.BinaryDocValuesUpdate.readFrom(in, scratch);
            }
            if (termsEnum == null || !termsEnum.seekExact(term)) continue;
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            DocValuesFieldUpdates dvUpdates = (DocValuesFieldUpdates)holder.get(updateField);
            if (dvUpdates == null) {
                dvUpdates = isNumeric ? new NumericDocValuesFieldUpdates(delGen, updateField, segState.reader.maxDoc()) : new BinaryDocValuesFieldUpdates(delGen, updateField, segState.reader.maxDoc());
                holder.put(updateField, dvUpdates);
            }
            DocValuesFieldUpdates update = dvUpdates;
            IntConsumer docIdConsumer = !hasValue ? doc -> update.reset(doc) : (isNumeric ? doc -> update.add(doc, longValue) : doc -> update.add(doc, binaryValue));
            Bits acceptDocs = segState.rld.getLiveDocs();
            if (segState.rld.sortMap != null && segmentPrivateDeletes) {
                while ((doc2 = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    if (acceptDocs != null && !acceptDocs.get(doc2) || segState.rld.sortMap.newToOld(doc2) >= limit) continue;
                    docIdConsumer.accept(doc2);
                    ++updateCount;
                }
                continue;
            }
            while ((doc2 = postingsEnum.nextDoc()) != Integer.MAX_VALUE && doc2 < limit) {
                if (acceptDocs != null && !acceptDocs.get(doc2)) continue;
                docIdConsumer.accept(doc2);
                ++updateCount;
            }
        }
        for (DocValuesFieldUpdates update : holder.values()) {
            if (!update.any()) continue;
            update.finish();
            segState.rld.addDVUpdate(update);
        }
        return updateCount;
    }

    private long applyQueryDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteQueries.length == 0) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            LeafReaderContext readerContext = segState.reader.getContext();
            for (int i = 0; i < this.deleteQueries.length; ++i) {
                int docID;
                int limit;
                Query query = this.deleteQueries[i];
                if (this.delGen == segState.delGen) {
                    assert (this.privateSegment != null);
                    limit = this.deleteQueryLimits[i];
                } else {
                    limit = Integer.MAX_VALUE;
                }
                IndexSearcher searcher = new IndexSearcher(readerContext.reader());
                searcher.setQueryCache(null);
                query = searcher.rewrite(query);
                Weight weight = searcher.createWeight(query, false, 1.0f);
                Scorer scorer = weight.scorer(readerContext);
                if (scorer == null) continue;
                DocIdSetIterator it = scorer.iterator();
                if (segState.rld.sortMap != null && limit != Integer.MAX_VALUE) {
                    assert (this.privateSegment != null);
                    while ((docID = it.nextDoc()) != Integer.MAX_VALUE) {
                        if (segState.rld.sortMap.newToOld(docID) >= limit || !segState.rld.delete(docID)) continue;
                        ++delCount;
                    }
                    continue;
                }
                while ((docID = it.nextDoc()) < limit) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyQueryDeletes took %.2f msec for %d segments and %d queries; %d new deletions", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.deleteQueries.length, delCount));
        }
        return delCount;
    }

    private long applyTermDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteTerms.size() == 0L) {
            return 0L;
        }
        assert (this.privateSegment == null);
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            BytesRef delTerm;
            assert (segState.delGen != this.delGen) : "segState.delGen=" + segState.delGen + " vs this.gen=" + this.delGen;
            if (segState.delGen > this.delGen || segState.rld.refCount() == 1) continue;
            PrefixCodedTerms.TermIterator iter = this.deleteTerms.iterator();
            String field = null;
            TermsEnum termsEnum = null;
            BytesRef readerTerm = null;
            PostingsEnum postingsEnum = null;
            while ((delTerm = iter.next()) != null) {
                int docID;
                TermsEnum.SeekStatus status;
                int cmp;
                if (((FieldTermIterator)iter).field() != field) {
                    field = ((FieldTermIterator)iter).field();
                    Terms terms = segState.reader.terms(field);
                    if (terms != null) {
                        termsEnum = terms.iterator();
                        readerTerm = termsEnum.next();
                    } else {
                        termsEnum = null;
                    }
                }
                if (termsEnum == null || (cmp = delTerm.compareTo(readerTerm)) < 0) continue;
                if (cmp != 0 && cmp > 0 && (status = termsEnum.seekCeil(delTerm)) != TermsEnum.SeekStatus.FOUND) {
                    if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                        readerTerm = termsEnum.term();
                        continue;
                    }
                    termsEnum = null;
                    continue;
                }
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                assert (postingsEnum != null);
                while ((docID = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.2f msec for %d segments and %d del terms; %d new deletions", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.deleteTerms.size(), delCount));
        }
        return delCount;
    }

    public void setDelGen(long delGen) {
        assert (this.delGen == -1L) : "delGen was already previously set to " + this.delGen;
        this.delGen = delGen;
        this.deleteTerms.setDelGen(delGen);
    }

    public long delGen() {
        assert (this.delGen != -1L);
        return this.delGen;
    }

    public String toString() {
        String s = "delGen=" + this.delGen;
        if (this.numTermDeletes != 0) {
            s = s + " numDeleteTerms=" + this.numTermDeletes;
            if ((long)this.numTermDeletes != this.deleteTerms.size()) {
                s = s + " (" + this.deleteTerms.size() + " unique)";
            }
        }
        if (this.deleteQueries.length != 0) {
            s = s + " numDeleteQueries=" + this.deleteQueries.length;
        }
        if (this.numericDVUpdates.length > 0) {
            s = s + " numNumericDVUpdates=" + this.numericDVUpdateCount;
        }
        if (this.binaryDVUpdates.length > 0) {
            s = s + " numBinaryDVUpdates=" + this.binaryDVUpdateCount;
        }
        if (this.bytesUsed != 0) {
            s = s + " bytesUsed=" + this.bytesUsed;
        }
        if (this.privateSegment != null) {
            s = s + " privateSegment=" + this.privateSegment;
        }
        return s;
    }

    boolean any() {
        return this.deleteTerms.size() > 0L || this.deleteQueries.length > 0 || this.numericDVUpdates.length > 0 || this.binaryDVUpdates.length > 0;
    }
}

