/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.index.DocumentsWriterPerThread;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.FieldInvertState;
import conductor.org.apache.lucene.index.SegmentWriteState;
import conductor.org.apache.lucene.index.Sorter;
import conductor.org.apache.lucene.index.TermsHashPerField;
import conductor.org.apache.lucene.util.ByteBlockPool;
import conductor.org.apache.lucene.util.Counter;
import conductor.org.apache.lucene.util.IntBlockPool;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

abstract class TermsHash {
    final TermsHash nextTermsHash;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final Counter bytesUsed;
    final DocumentsWriterPerThread.DocState docState;
    final boolean trackAllocations;

    TermsHash(DocumentsWriterPerThread docWriter, boolean trackAllocations, TermsHash nextTermsHash) {
        this.docState = docWriter.docState;
        this.trackAllocations = trackAllocations;
        this.nextTermsHash = nextTermsHash;
        this.bytesUsed = trackAllocations ? docWriter.bytesUsed : Counter.newCounter();
        this.intPool = new IntBlockPool(docWriter.intBlockAllocator);
        this.bytePool = new ByteBlockPool(docWriter.byteBlockAllocator);
        if (nextTermsHash != null) {
            this.termBytePool = this.bytePool;
            nextTermsHash.termBytePool = this.bytePool;
        }
    }

    public void abort() {
        try {
            this.reset();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    void reset() {
        this.intPool.reset(false, false);
        this.bytePool.reset(false, false);
    }

    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        if (this.nextTermsHash != null) {
            HashMap<String, TermsHashPerField> nextChildFields = new HashMap<String, TermsHashPerField>();
            for (Map.Entry<String, TermsHashPerField> entry : fieldsToFlush.entrySet()) {
                nextChildFields.put(entry.getKey(), entry.getValue().nextPerField);
            }
            this.nextTermsHash.flush(nextChildFields, state, sortMap);
        }
    }

    abstract TermsHashPerField addField(FieldInvertState var1, FieldInfo var2);

    void finishDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.finishDocument();
        }
    }

    void startDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.startDocument();
        }
    }
}

