/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.intervals;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.TermContext;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.FilterMatchesIterator;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Matches;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.search.MatchesUtils;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.intervals.IntervalIterator;
import conductor.org.apache.lucene.search.intervals.IntervalScorer;
import conductor.org.apache.lucene.search.intervals.IntervalsSource;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.util.ArrayUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class IntervalQuery
extends Query {
    private final String field;
    private final IntervalsSource intervalsSource;

    public IntervalQuery(String field, IntervalsSource intervalsSource) {
        this.field = field;
        this.intervalsSource = intervalsSource;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field) {
        return this.intervalsSource.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new IntervalWeight(this, needsScores ? this.buildSimScorer(searcher, needsScores, boost) : null, searcher.getSimilarity(needsScores), needsScores);
    }

    private Similarity.SimWeight buildSimScorer(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        HashSet<Term> terms = new HashSet<Term>();
        this.intervalsSource.extractTerms(this.field, terms);
        TermStatistics[] termStats = new TermStatistics[terms.size()];
        int termUpTo = 0;
        for (Term term : terms) {
            TermStatistics termStatistics = searcher.termStatistics(term, TermContext.build(searcher.getTopReaderContext(), term));
            if (termStatistics == null) continue;
            termStats[termUpTo++] = termStatistics;
        }
        if (termUpTo == 0) {
            return null;
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(this.field);
        return searcher.getSimilarity(needsScores).computeWeight(boost, collectionStats, ArrayUtil.copyOfSubArray(termStats, 0, termUpTo));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalQuery that = (IntervalQuery)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.intervalsSource, that.intervalsSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.intervalsSource);
    }

    private class IntervalWeight
    extends Weight {
        final Similarity.SimWeight simWeight;
        final Similarity similarity;
        final boolean needsScores;

        public IntervalWeight(Query query, Similarity.SimWeight simWeight, Similarity similarity, boolean needsScores) {
            super(query);
            this.simWeight = simWeight;
            this.similarity = similarity;
            this.needsScores = needsScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            IntervalQuery.this.intervalsSource.extractTerms(IntervalQuery.this.field, terms);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            IntervalScorer scorer = (IntervalScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                return scorer.explain("weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "]");
            }
            return Explanation.noMatch("no matching intervals", new Explanation[0]);
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return MatchesUtils.forField(IntervalQuery.this.field, () -> {
                MatchesIterator mi = IntervalQuery.this.intervalsSource.matches(IntervalQuery.this.field, context, doc);
                if (mi == null) {
                    return null;
                }
                return new FilterMatchesIterator(mi){

                    @Override
                    public Query getQuery() {
                        return new IntervalQuery(IntervalQuery.this.field, IntervalQuery.this.intervalsSource);
                    }
                };
            });
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            IntervalIterator intervals = IntervalQuery.this.intervalsSource.intervals(IntervalQuery.this.field, context);
            if (intervals == null) {
                return null;
            }
            Similarity.SimScorer leafScorer = this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
            return new IntervalScorer(this, intervals, leafScorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

