/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.fst;

import conductor.org.apache.lucene.search.suggest.InputIterator;
import conductor.org.apache.lucene.search.suggest.Lookup;
import conductor.org.apache.lucene.search.suggest.SortedInputIterator;
import conductor.org.apache.lucene.store.ByteArrayDataInput;
import conductor.org.apache.lucene.store.ByteArrayDataOutput;
import conductor.org.apache.lucene.store.DataInput;
import conductor.org.apache.lucene.store.DataOutput;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.apache.lucene.util.Accountables;
import conductor.org.apache.lucene.util.ArrayUtil;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.apache.lucene.util.CharsRefBuilder;
import conductor.org.apache.lucene.util.IntsRefBuilder;
import conductor.org.apache.lucene.util.OfflineSorter;
import conductor.org.apache.lucene.util.fst.Builder;
import conductor.org.apache.lucene.util.fst.FST;
import conductor.org.apache.lucene.util.fst.PositiveIntOutputs;
import conductor.org.apache.lucene.util.fst.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class WFSTCompletionLookup
extends Lookup
implements Accountable {
    private FST<Long> fst = null;
    private final boolean exactFirst;
    private long count = 0L;
    private final Directory tempDir;
    private final String tempFileNamePrefix;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public WFSTCompletionLookup(Directory tempDir, String tempFileNamePrefix) {
        this(tempDir, tempFileNamePrefix, true);
    }

    public WFSTCompletionLookup(Directory tempDir, String tempFileNamePrefix, boolean exactFirst) {
        this.exactFirst = exactFirst;
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    @Override
    public void build(InputIterator iterator) throws IOException {
        if (iterator.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (iterator.hasContexts()) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        this.count = 0L;
        BytesRef scratch = new BytesRef();
        WFSTInputIterator iter = new WFSTInputIterator(this.tempDir, this.tempFileNamePrefix, iterator);
        IntsRefBuilder scratchInts = new IntsRefBuilder();
        BytesRefBuilder previous = null;
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder<Long> builder = new Builder<Long>(FST.INPUT_TYPE.BYTE1, outputs);
        while ((scratch = iter.next()) != null) {
            long cost = iter.weight();
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else if (scratch.equals(previous.get())) continue;
            Util.toIntsRef(scratch, scratchInts);
            builder.add(scratchInts.get(), cost);
            previous.copyBytes(scratch);
            ++this.count;
        }
        this.fst = builder.finish();
    }

    @Override
    public boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.fst == null) {
            return false;
        }
        this.fst.save(output);
        return true;
    }

    @Override
    public boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.fst = new FST<Long>(input, PositiveIntOutputs.getSingleton());
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        scratch.copyChars(key);
        int prefixLength = scratch.length();
        FST.Arc<Long> arc = new FST.Arc<Long>();
        Long prefixOutput = null;
        try {
            prefixOutput = this.lookupPrefix(scratch.get(), arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (prefixOutput == null) {
            return Collections.emptyList();
        }
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
        CharsRefBuilder spare = new CharsRefBuilder();
        if (this.exactFirst && arc.isFinal()) {
            spare.copyUTF8Bytes(scratch.get());
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight(prefixOutput + (Long)arc.nextFinalOutput)));
            if (--num == 0) {
                return results;
            }
        }
        Util.TopResults<Long> completions = null;
        try {
            completions = Util.shortestPaths(this.fst, arc, prefixOutput, weightComparator, num, !this.exactFirst);
            assert (completions.isComplete);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        BytesRefBuilder suffix = new BytesRefBuilder();
        for (Util.Result<Long> result : completions) {
            scratch.setLength(prefixLength);
            Util.toBytesRef(result.input, suffix);
            scratch.append(suffix);
            spare.copyUTF8Bytes(scratch.get());
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight((Long)result.output)));
        }
        return results;
    }

    private Long lookupPrefix(BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        assert (0L == (Long)this.fst.outputs.getNoOutput());
        long output = 0L;
        FST.BytesReader bytesReader = this.fst.getBytesReader();
        this.fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (this.fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output += ((Long)arc.output).longValue();
        }
        return output;
    }

    public Object get(CharSequence key) {
        if (this.fst == null) {
            return null;
        }
        FST.Arc<Long> arc = new FST.Arc<Long>();
        Long result = null;
        try {
            result = this.lookupPrefix(new BytesRef(key), arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (result == null || !arc.isFinal()) {
            return null;
        }
        return WFSTCompletionLookup.decodeWeight(result + (Long)arc.nextFinalOutput);
    }

    private static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    private static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    @Override
    public long ramBytesUsed() {
        return this.fst == null ? 0L : this.fst.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        if (this.fst == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(Accountables.namedAccountable("fst", this.fst));
    }

    @Override
    public long getCount() {
        return this.count;
    }

    private static final class WFSTInputIterator
    extends SortedInputIterator {
        WFSTInputIterator(Directory tempDir, String tempFileNamePrefix, InputIterator source) throws IOException {
            super(tempDir, tempFileNamePrefix, source);
            assert (!source.hasPayloads());
        }

        @Override
        protected void encode(OfflineSorter.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, BytesRef payload, Set<BytesRef> contexts, long weight) throws IOException {
            if (spare.length + 4 >= buffer.length) {
                buffer = ArrayUtil.grow(buffer, spare.length + 4);
            }
            output.reset(buffer);
            output.writeBytes(spare.bytes, spare.offset, spare.length);
            output.writeInt(WFSTCompletionLookup.encodeWeight(weight));
            writer.write(buffer, 0, output.getPosition());
        }

        @Override
        protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
            scratch.length -= 4;
            tmpInput.reset(scratch.bytes, scratch.offset + scratch.length, 4);
            return tmpInput.readInt();
        }
    }
}

