/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.uhighlight;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import conductor.org.apache.lucene.search.uhighlight.OffsetsEnum;
import conductor.org.apache.lucene.search.uhighlight.Passage;
import conductor.org.apache.lucene.search.uhighlight.PassageFormatter;
import conductor.org.apache.lucene.search.uhighlight.PassageScorer;
import conductor.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;

public class FieldHighlighter {
    protected final String field;
    protected final FieldOffsetStrategy fieldOffsetStrategy;
    protected final BreakIterator breakIterator;
    protected final PassageScorer passageScorer;
    protected final int maxPassages;
    protected final int maxNoHighlightPassages;
    protected final PassageFormatter passageFormatter;

    public FieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter) {
        this.field = field;
        this.fieldOffsetStrategy = fieldOffsetStrategy;
        this.breakIterator = breakIterator;
        this.passageScorer = passageScorer;
        this.maxPassages = maxPassages;
        this.maxNoHighlightPassages = maxNoHighlightPassages;
        this.passageFormatter = passageFormatter;
    }

    public String getField() {
        return this.field;
    }

    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return this.fieldOffsetStrategy.getOffsetSource();
    }

    public Object highlightFieldForDoc(LeafReader reader, int docId, String content) throws IOException {
        if (content.length() == 0) {
            return null;
        }
        this.breakIterator.setText(content);
        try (OffsetsEnum offsetsEnums = this.fieldOffsetStrategy.getOffsetsEnum(reader, docId, content);){
            Passage[] passages = this.highlightOffsetsEnums(offsetsEnums);
            if (passages.length == 0) {
                passages = this.getSummaryPassagesNoHighlight(this.maxNoHighlightPassages == -1 ? this.maxPassages : this.maxNoHighlightPassages);
            }
            if (passages.length > 0) {
                Object object = this.passageFormatter.format(passages, content);
                return object;
            }
            Object var7_9 = null;
            return var7_9;
        }
    }

    protected Passage[] getSummaryPassagesNoHighlight(int maxPassages) {
        int next;
        assert (this.breakIterator.current() == this.breakIterator.first());
        ArrayList<Passage> passages = new ArrayList<Passage>(Math.min(maxPassages, 10));
        int pos = this.breakIterator.current();
        assert (pos == 0);
        while (passages.size() < maxPassages && (next = this.breakIterator.next()) != -1) {
            Passage passage = new Passage();
            passage.setStartOffset(pos);
            passage.setEndOffset(next);
            passages.add(passage);
            pos = next;
        }
        return passages.toArray(new Passage[passages.size()]);
    }

    protected Passage[] highlightOffsetsEnums(OffsetsEnum off) throws IOException {
        int contentLength = this.breakIterator.getText().getEndIndex();
        if (!off.nextPosition()) {
            return new Passage[0];
        }
        PriorityQueue<Passage> passageQueue = new PriorityQueue<Passage>(Math.min(64, this.maxPassages + 1), (left, right) -> {
            if (left.getScore() < right.getScore()) {
                return -1;
            }
            if (left.getScore() > right.getScore()) {
                return 1;
            }
            return left.getStartOffset() - right.getStartOffset();
        });
        Passage passage = new Passage();
        do {
            int start;
            if ((start = off.startOffset()) == -1) {
                throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
            }
            int end = off.endOffset();
            if (start < contentLength && end > contentLength) continue;
            if (start >= passage.getEndOffset()) {
                passage = this.maybeAddPassage(passageQueue, this.passageScorer, passage, contentLength);
                if (start >= contentLength) break;
                passage.setStartOffset(Math.max(this.breakIterator.preceding(start + 1), 0));
                passage.setEndOffset(Math.min(this.breakIterator.following(start), contentLength));
            }
            BytesRef term = off.getTerm();
            assert (term != null);
            passage.addMatch(start, end, term, off.freq());
        } while (off.nextPosition());
        this.maybeAddPassage(passageQueue, this.passageScorer, passage, contentLength);
        Passage[] passages = passageQueue.toArray(new Passage[passageQueue.size()]);
        Arrays.sort(passages, Comparator.comparingInt(Passage::getStartOffset));
        return passages;
    }

    private Passage maybeAddPassage(PriorityQueue<Passage> passageQueue, PassageScorer scorer, Passage passage, int contentLength) {
        if (passage.getStartOffset() == -1) {
            return passage;
        }
        passage.setScore(scorer.score(passage, contentLength));
        if (passageQueue.size() == this.maxPassages && passage.getScore() < passageQueue.peek().getScore()) {
            passage.reset();
        } else {
            passageQueue.offer(passage);
            if (passageQueue.size() > this.maxPassages) {
                passage = passageQueue.poll();
                passage.reset();
            } else {
                passage = new Passage();
            }
        }
        return passage;
    }
}

