/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.uhighlight;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.FilteringTokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.memory.MemoryIndex;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import conductor.org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import conductor.org.apache.lucene.search.uhighlight.OffsetsEnum;
import conductor.org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import conductor.org.apache.lucene.search.uhighlight.UHComponents;
import conductor.org.apache.lucene.util.automaton.Automata;
import conductor.org.apache.lucene.util.automaton.CharacterRunAutomaton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public class MemoryIndexOffsetStrategy
extends AnalysisOffsetStrategy {
    private final MemoryIndex memoryIndex;
    private final LeafReader memIndexLeafReader;
    private final CharacterRunAutomaton preMemIndexFilterAutomaton;

    public MemoryIndexOffsetStrategy(UHComponents components, Analyzer analyzer, Function<Query, Collection<Query>> multiTermQueryRewrite) {
        super(components, analyzer);
        boolean storePayloads = components.getPhraseHelper().hasPositionSensitivity();
        this.memoryIndex = new MemoryIndex(true, storePayloads);
        this.memIndexLeafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
        this.preMemIndexFilterAutomaton = MemoryIndexOffsetStrategy.buildCombinedAutomaton(components, multiTermQueryRewrite);
    }

    private static CharacterRunAutomaton buildCombinedAutomaton(UHComponents components, Function<Query, Collection<Query>> multiTermQueryRewrite) {
        final ArrayList<CharacterRunAutomaton> allAutomata = new ArrayList<CharacterRunAutomaton>();
        if (components.getTerms().length > 0) {
            allAutomata.add(new CharacterRunAutomaton(Automata.makeStringUnion(Arrays.asList(components.getTerms()))));
        }
        Collections.addAll(allAutomata, components.getAutomata());
        for (SpanQuery spanQuery : components.getPhraseHelper().getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata(spanQuery, components.getFieldMatcher(), true, multiTermQueryRewrite));
        }
        if (allAutomata.size() == 1) {
            return (CharacterRunAutomaton)allAutomata.get(0);
        }
        return new CharacterRunAutomaton(Automata.makeEmpty()){

            @Override
            public boolean run(char[] chars, int offset, int length) {
                for (int i = 0; i < allAutomata.size(); ++i) {
                    if (!((CharacterRunAutomaton)allAutomata.get(i)).run(chars, offset, length)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        tokenStream = MemoryIndexOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
        this.memoryIndex.reset();
        this.memoryIndex.addField(this.getField(), tokenStream);
        if (reader == null) {
            return this.createOffsetsEnumFromReader(this.memIndexLeafReader, 0);
        }
        return this.createOffsetsEnumFromReader(new OverlaySingleDocTermsLeafReader(reader, this.memIndexLeafReader, this.getField(), docId), docId);
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharacterRunAutomaton charRunAutomaton) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(x0);
                this.charAtt = this.addAttribute(CharTermAttribute.class);
            }

            @Override
            protected boolean accept() throws IOException {
                return charRunAutomaton.run(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }
}

