/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.uhighlight;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import conductor.org.apache.lucene.search.uhighlight.OffsetsEnum;
import conductor.org.apache.lucene.search.uhighlight.TermVectorFilteredLeafReader;
import conductor.org.apache.lucene.search.uhighlight.UHComponents;
import conductor.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import java.io.IOException;

public class PostingsWithTermVectorsOffsetStrategy
extends FieldOffsetStrategy {
    public PostingsWithTermVectorsOffsetStrategy(UHComponents components) {
        super(components);
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader leafReader, int docId, String content) throws IOException {
        Terms docTerms = leafReader.getTermVector(docId, this.getField());
        if (docTerms == null) {
            return OffsetsEnum.EMPTY;
        }
        leafReader = new TermVectorFilteredLeafReader(leafReader, docTerms, this.getField());
        return this.createOffsetsEnumFromReader(leafReader, docId);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS;
    }
}

