/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial.prefix;

import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermInSetQuery;
import conductor.org.apache.lucene.spatial.prefix.CellToBytesRefIterator;
import conductor.org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import conductor.org.apache.lucene.spatial.prefix.tree.Cell;
import conductor.org.apache.lucene.spatial.prefix.tree.CellIterator;
import conductor.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import conductor.org.apache.lucene.spatial.query.SpatialArgs;
import conductor.org.apache.lucene.spatial.query.SpatialOperation;
import conductor.org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import java.util.ArrayList;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class TermQueryPrefixTreeStrategy
extends PrefixTreeStrategy {
    protected boolean simplifyIndexedCells = false;

    public TermQueryPrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
    }

    @Override
    protected CellToBytesRefIterator newCellToBytesRefIterator() {
        return new CellToBytesRefIterator(){

            @Override
            public BytesRef next() {
                if (!this.cellIter.hasNext()) {
                    return null;
                }
                return ((Cell)this.cellIter.next()).getTokenBytesNoLeaf(this.bytesRef);
            }
        };
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (op != SpatialOperation.Intersects) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        int GUESS_NUM_TERMS = shape instanceof Point ? detailLevel : 4096;
        BytesRefBuilder masterBytes = new BytesRefBuilder();
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>(GUESS_NUM_TERMS);
        CellIterator cells = this.grid.getTreeCellIterator(shape, detailLevel);
        while (cells.hasNext()) {
            Cell cell = cells.next();
            if (!cell.isLeaf()) continue;
            BytesRef term = cell.getTokenBytesNoLeaf(null);
            masterBytes.grow(masterBytes.length() + term.length);
            masterBytes.append(term);
            term.bytes = null;
            term.offset = masterBytes.length() - term.length;
            terms.add(term);
        }
        for (BytesRef byteRef : terms) {
            byteRef.bytes = masterBytes.bytes();
        }
        return new TermInSetQuery(this.getFieldName(), terms);
    }
}

