/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.hotthreads;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import conductor.org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import conductor.org.elasticsearch.action.support.nodes.TransportNodesAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.monitor.jvm.HotThreads;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.List;

public class TransportNodesHotThreadsAction
extends TransportNodesAction<NodesHotThreadsRequest, NodesHotThreadsResponse, NodeRequest, NodeHotThreads> {
    @Inject
    public TransportNodesHotThreadsAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/nodes/hot_threads", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, NodesHotThreadsRequest::new, NodeRequest::new, "generic", NodeHotThreads.class);
    }

    @Override
    protected NodesHotThreadsResponse newResponse(NodesHotThreadsRequest request, List<NodeHotThreads> responses, List<FailedNodeException> failures) {
        return new NodesHotThreadsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, NodesHotThreadsRequest request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeHotThreads newNodeResponse() {
        return new NodeHotThreads();
    }

    @Override
    protected NodeHotThreads nodeOperation(NodeRequest request) {
        HotThreads hotThreads = new HotThreads().busiestThreads(request.request.threads).type(request.request.type).interval(request.request.interval).threadElementsSnapshotCount(request.request.snapshots).ignoreIdleThreads(request.request.ignoreIdleThreads);
        try {
            return new NodeHotThreads(this.clusterService.localNode(), hotThreads.detect());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to detect hot threads", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodesHotThreadsRequest request;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, NodesHotThreadsRequest request) {
            super(nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesHotThreadsRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

