/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.state;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.routing.RoutingTable;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.discovery.zen.PublishClusterStateAction;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;

public class TransportClusterStateAction
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    @Inject
    public TransportClusterStateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterStateRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected ClusterStateResponse newResponse() {
        return new ClusterStateResponse();
    }

    @Override
    protected void masterOperation(ClusterStateRequest request, ClusterState state, ActionListener<ClusterStateResponse> listener) throws IOException {
        String[] indices;
        ClusterState currentState = this.clusterService.state();
        this.logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        MetaData.Builder mdBuilder = MetaData.builder();
        mdBuilder.clusterUUID(currentState.metaData().clusterUUID());
        if (request.metaData()) {
            if (request.indices().length > 0) {
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    IndexMetaData indexMetaData = currentState.metaData().index(filteredIndex);
                    if (indexMetaData == null) continue;
                    mdBuilder.put(indexMetaData, false);
                }
            } else {
                mdBuilder = MetaData.builder(currentState.metaData());
            }
            for (ObjectObjectCursor<String, ToXContentFragment> objectObjectCursor : currentState.metaData().customs()) {
                if (((MetaData.Custom)objectObjectCursor.value).context().contains((Object)MetaData.XContentContext.API)) continue;
                mdBuilder.removeCustom((String)objectObjectCursor.key);
            }
        }
        builder.metaData(mdBuilder);
        if (request.customs()) {
            for (ObjectObjectCursor<String, ToXContentFragment> objectObjectCursor : currentState.customs()) {
                if (((ClusterState.Custom)objectObjectCursor.value).isPrivate()) continue;
                builder.putCustom((String)objectObjectCursor.key, (ClusterState.Custom)objectObjectCursor.value);
            }
        }
        listener.onResponse(new ClusterStateResponse(currentState.getClusterName(), builder.build(), PublishClusterStateAction.serializeFullClusterState(currentState, Version.CURRENT).length()));
    }
}

