/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.mapping.put;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import conductor.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MetaDataMappingService;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends TransportMasterNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public TransportPutMappingAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutMappingRequest::new);
        this.metaDataMappingService = metaDataMappingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(final PutMappingRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        try {
            Index[] indexArray;
            if (request.getConcreteIndex() == null) {
                indexArray = this.indexNameExpressionResolver.concreteIndices(state, request);
            } else {
                Index[] indexArray2 = new Index[1];
                indexArray = indexArray2;
                indexArray2[0] = request.getConcreteIndex();
            }
            final Index[] concreteIndices = indexArray;
            PutMappingClusterStateUpdateRequest updateRequest = ((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).type(request.type()).updateAllTypes(request.updateAllTypes()).source(request.source());
            this.metaDataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                @Override
                public void onResponse(ClusterStateUpdateResponse response) {
                    listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
                }

                @Override
                public void onFailure(Exception t) {
                    TransportPutMappingAction.this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)concreteIndices, (Object)request.type()), (Throwable)t);
                    listener.onFailure(t);
                }
            });
        }
        catch (IndexNotFoundException ex) {
            this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)request.indices(), (Object)request.type()), (Throwable)ex);
            throw ex;
        }
    }
}

