/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.validate.query;

import conductor.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import java.io.IOException;
import java.util.Objects;

public class ShardValidateQueryRequest
extends BroadcastShardRequest {
    private QueryBuilder query;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean explain;
    private boolean rewrite;
    private long nowInMillis;
    private AliasFilter filteringAliases;

    public ShardValidateQueryRequest() {
    }

    public ShardValidateQueryRequest(ShardId shardId, AliasFilter filteringAliases, ValidateQueryRequest request) {
        super(shardId, request);
        this.query = request.query();
        this.types = request.types();
        this.explain = request.explain();
        this.rewrite = request.rewrite();
        this.filteringAliases = Objects.requireNonNull(filteringAliases, "filteringAliases must not be null");
        this.nowInMillis = request.nowInMillis;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public String[] types() {
        return this.types;
    }

    public boolean explain() {
        return this.explain;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public AliasFilter filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.query = in.readNamedWriteable(QueryBuilder.class);
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
        this.filteringAliases = new AliasFilter(in);
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.nowInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable(this.query);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
        this.filteringAliases.writeTo(out);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeVLong(this.nowInMillis);
    }
}

