/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.bulk;

import conductor.org.elasticsearch.action.DocWriteRequest;
import conductor.org.elasticsearch.action.bulk.BulkItemResponse;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import java.io.IOException;
import java.util.Objects;

public class BulkItemRequest
implements Streamable {
    private int id;
    private DocWriteRequest request;
    private volatile BulkItemResponse primaryResponse;

    BulkItemRequest() {
    }

    public BulkItemRequest(int id, DocWriteRequest request) {
        this.id = id;
        this.request = request;
    }

    public int id() {
        return this.id;
    }

    public DocWriteRequest request() {
        return this.request;
    }

    public String index() {
        assert (this.request.indices().length == 1);
        return this.request.indices()[0];
    }

    BulkItemResponse getPrimaryResponse() {
        return this.primaryResponse;
    }

    void setPrimaryResponse(BulkItemResponse primaryResponse) {
        this.primaryResponse = primaryResponse;
    }

    public void abort(String index, Exception cause) {
        if (this.primaryResponse == null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(index, this.request.type(), this.request.id(), Objects.requireNonNull(cause), true);
            this.setPrimaryResponse(new BulkItemResponse(this.id, this.request.opType(), failure));
        } else {
            assert (this.primaryResponse.isFailed() && this.primaryResponse.getFailure().isAborted()) : "response [" + Strings.toString(this.primaryResponse) + "]; cause [" + cause + "]";
            if (this.primaryResponse.isFailed() && this.primaryResponse.getFailure().isAborted()) {
                this.primaryResponse.getFailure().getCause().addSuppressed(cause);
            } else {
                throw new IllegalStateException("aborting item that with response [" + this.primaryResponse + "] that was previously processed", cause);
            }
        }
    }

    public static BulkItemRequest readBulkItem(StreamInput in) throws IOException {
        BulkItemRequest item = new BulkItemRequest();
        item.readFrom(in);
        return item;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.request = DocWriteRequest.readDocumentRequest(in);
        if (in.readBoolean()) {
            this.primaryResponse = BulkItemResponse.readBulkItem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        DocWriteRequest.writeDocumentRequest(out, this.request);
        out.writeOptionalStreamable(this.primaryResponse);
    }
}

