/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.get;

import conductor.org.elasticsearch.action.RoutingMissingException;
import conductor.org.elasticsearch.action.get.GetRequest;
import conductor.org.elasticsearch.action.get.GetResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexService;
import conductor.org.elasticsearch.index.get.GetResult;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportGetAction
extends TransportSingleShardAction<GetRequest, GetResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportGetAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/get", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(GetRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((GetRequest)request.request()).id(), ((GetRequest)request.request()).routing(), ((GetRequest)request.request()).preference());
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        IndexMetaData indexMeta = state.getMetaData().index(request.concreteIndex());
        ((GetRequest)request.request()).routing(state.metaData().resolveIndexRouting(((GetRequest)request.request()).parent(), ((GetRequest)request.request()).routing(), ((GetRequest)request.request()).index()));
        if (((GetRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((GetRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((GetRequest)request.request()).type(), ((GetRequest)request.request()).id());
        }
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_get");
        }
        GetResult result = indexShard.getService().get(request.type(), request.id(), request.storedFields(), request.realtime(), request.version(), request.versionType(), request.fetchSourceContext());
        return new GetResponse(result);
    }

    @Override
    protected GetResponse newResponse() {
        return new GetResponse();
    }

    @Override
    protected String getExecutor(GetRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

