/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.broadcast;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.transport.TransportResponse;
import java.io.IOException;

public abstract class BroadcastShardResponse
extends TransportResponse {
    ShardId shardId;

    protected BroadcastShardResponse() {
    }

    protected BroadcastShardResponse(ShardId shardId) {
        this.shardId = shardId;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = ShardId.readShardId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
    }
}

