/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.Header;
import conductor.org.apache.http.HttpEntity;
import conductor.org.elasticsearch.ElasticsearchStatusException;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import conductor.org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import conductor.org.elasticsearch.action.bulk.BulkRequest;
import conductor.org.elasticsearch.action.bulk.BulkResponse;
import conductor.org.elasticsearch.action.delete.DeleteRequest;
import conductor.org.elasticsearch.action.delete.DeleteResponse;
import conductor.org.elasticsearch.action.explain.ExplainRequest;
import conductor.org.elasticsearch.action.explain.ExplainResponse;
import conductor.org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import conductor.org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import conductor.org.elasticsearch.action.get.GetRequest;
import conductor.org.elasticsearch.action.get.GetResponse;
import conductor.org.elasticsearch.action.get.MultiGetRequest;
import conductor.org.elasticsearch.action.get.MultiGetResponse;
import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.index.IndexResponse;
import conductor.org.elasticsearch.action.main.MainRequest;
import conductor.org.elasticsearch.action.main.MainResponse;
import conductor.org.elasticsearch.action.search.ClearScrollRequest;
import conductor.org.elasticsearch.action.search.ClearScrollResponse;
import conductor.org.elasticsearch.action.search.MultiSearchRequest;
import conductor.org.elasticsearch.action.search.MultiSearchResponse;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.action.update.UpdateRequest;
import conductor.org.elasticsearch.action.update.UpdateResponse;
import conductor.org.elasticsearch.client.ClusterClient;
import conductor.org.elasticsearch.client.GraphClient;
import conductor.org.elasticsearch.client.IndicesClient;
import conductor.org.elasticsearch.client.IngestClient;
import conductor.org.elasticsearch.client.LicenseClient;
import conductor.org.elasticsearch.client.MachineLearningClient;
import conductor.org.elasticsearch.client.MigrationClient;
import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.RequestConverters;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.Response;
import conductor.org.elasticsearch.client.ResponseException;
import conductor.org.elasticsearch.client.ResponseListener;
import conductor.org.elasticsearch.client.RestClient;
import conductor.org.elasticsearch.client.RestClientBuilder;
import conductor.org.elasticsearch.client.RethrottleRequest;
import conductor.org.elasticsearch.client.RollupClient;
import conductor.org.elasticsearch.client.SecurityClient;
import conductor.org.elasticsearch.client.SnapshotClient;
import conductor.org.elasticsearch.client.TasksClient;
import conductor.org.elasticsearch.client.Validatable;
import conductor.org.elasticsearch.client.ValidationException;
import conductor.org.elasticsearch.client.WatcherClient;
import conductor.org.elasticsearch.client.XPackClient;
import conductor.org.elasticsearch.common.CheckedConsumer;
import conductor.org.elasticsearch.common.CheckedFunction;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ContextParser;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.rankeval.RankEvalRequest;
import conductor.org.elasticsearch.index.rankeval.RankEvalResponse;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import conductor.org.elasticsearch.index.reindex.ReindexRequest;
import conductor.org.elasticsearch.index.reindex.UpdateByQueryRequest;
import conductor.org.elasticsearch.plugins.spi.NamedXContentProvider;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import conductor.org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import conductor.org.elasticsearch.script.mustache.SearchTemplateResponse;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import conductor.org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import conductor.org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import conductor.org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import conductor.org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.ParsedAutoDateHistogram;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import conductor.org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import conductor.org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import conductor.org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import conductor.org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import conductor.org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import conductor.org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import conductor.org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import conductor.org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantLongTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantStringTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import conductor.org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import conductor.org.elasticsearch.search.aggregations.metrics.cardinality.ParsedCardinality;
import conductor.org.elasticsearch.search.aggregations.metrics.geobounds.ParsedGeoBounds;
import conductor.org.elasticsearch.search.aggregations.metrics.geocentroid.ParsedGeoCentroid;
import conductor.org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import conductor.org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import conductor.org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentileRanks;
import conductor.org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentiles;
import conductor.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentileRanks;
import conductor.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentiles;
import conductor.org.elasticsearch.search.aggregations.metrics.scripted.ParsedScriptedMetric;
import conductor.org.elasticsearch.search.aggregations.metrics.stats.ParsedStats;
import conductor.org.elasticsearch.search.aggregations.metrics.stats.extended.ParsedExtendedStats;
import conductor.org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import conductor.org.elasticsearch.search.aggregations.metrics.tophits.ParsedTopHits;
import conductor.org.elasticsearch.search.aggregations.metrics.valuecount.ParsedValueCount;
import conductor.org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.ParsedBucketMetricValue;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.ParsedPercentilesBucket;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.ParsedStatsBucket;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ParsedExtendedStatsBucket;
import conductor.org.elasticsearch.search.aggregations.pipeline.derivative.ParsedDerivative;
import conductor.org.elasticsearch.search.suggest.Suggest;
import conductor.org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import conductor.org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import conductor.org.elasticsearch.search.suggest.term.TermSuggestion;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestHighLevelClient
implements Closeable {
    private final RestClient client;
    private final NamedXContentRegistry registry;
    private final CheckedConsumer<RestClient, IOException> doClose;
    private final IndicesClient indicesClient = new IndicesClient(this);
    private final ClusterClient clusterClient = new ClusterClient(this);
    private final IngestClient ingestClient = new IngestClient(this);
    private final SnapshotClient snapshotClient = new SnapshotClient(this);
    private final TasksClient tasksClient = new TasksClient(this);
    private final XPackClient xPackClient = new XPackClient(this);
    private final WatcherClient watcherClient = new WatcherClient(this);
    private final GraphClient graphClient = new GraphClient(this);
    private final LicenseClient licenseClient = new LicenseClient(this);
    private final MigrationClient migrationClient = new MigrationClient(this);
    private final MachineLearningClient machineLearningClient = new MachineLearningClient(this);
    private final SecurityClient securityClient = new SecurityClient(this);
    private final RollupClient rollupClient = new RollupClient(this);
    private static final DeprecationHandler DEPRECATION_HANDLER = new DeprecationHandler(){

        @Override
        public void usedDeprecatedName(String usedName, String modernName) {
        }

        @Override
        public void usedDeprecatedField(String usedName, String replacedWith) {
        }
    };

    public RestHighLevelClient(RestClientBuilder restClientBuilder) {
        this(restClientBuilder, Collections.emptyList());
    }

    protected RestHighLevelClient(RestClientBuilder restClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        this(restClientBuilder.build(), RestClient::close, namedXContentEntries);
    }

    protected RestHighLevelClient(RestClient restClient, CheckedConsumer<RestClient, IOException> doClose, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        this.client = Objects.requireNonNull(restClient, "restClient must not be null");
        this.doClose = Objects.requireNonNull(doClose, "doClose consumer must not be null");
        this.registry = new NamedXContentRegistry(Stream.of(RestHighLevelClient.getDefaultNamedXContents().stream(), RestHighLevelClient.getProvidedNamedXContents().stream(), namedXContentEntries.stream()).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    public final RestClient getLowLevelClient() {
        return this.client;
    }

    @Override
    public final void close() throws IOException {
        this.doClose.accept(this.client);
    }

    public final IndicesClient indices() {
        return this.indicesClient;
    }

    public final ClusterClient cluster() {
        return this.clusterClient;
    }

    public final IngestClient ingest() {
        return this.ingestClient;
    }

    public final SnapshotClient snapshot() {
        return this.snapshotClient;
    }

    public RollupClient rollup() {
        return this.rollupClient;
    }

    public final TasksClient tasks() {
        return this.tasksClient;
    }

    public final XPackClient xpack() {
        return this.xPackClient;
    }

    public WatcherClient watcher() {
        return this.watcherClient;
    }

    public GraphClient graph() {
        return this.graphClient;
    }

    public LicenseClient license() {
        return this.licenseClient;
    }

    public MigrationClient migration() {
        return this.migrationClient;
    }

    public MachineLearningClient machineLearning() {
        return this.machineLearningClient;
    }

    public SecurityClient security() {
        return this.securityClient;
    }

    public final BulkResponse bulk(BulkRequest bulkRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final BulkResponse bulk(BulkRequest bulkRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(bulkRequest, RequestConverters::bulk, BulkResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void bulkAsync(BulkRequest bulkRequest, RequestOptions options, ActionListener<BulkResponse> listener) {
        this.performRequestAsyncAndParseEntity(bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void bulkAsync(BulkRequest bulkRequest, ActionListener<BulkResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(bulkRequest, RequestConverters::bulk, BulkResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final BulkByScrollResponse reindex(ReindexRequest reindexRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(reindexRequest, RequestConverters::reindex, options, BulkByScrollResponse::fromXContent, Collections.emptySet());
    }

    public final void reindexAsync(ReindexRequest reindexRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(reindexRequest, RequestConverters::reindex, options, BulkByScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final BulkByScrollResponse updateByQuery(UpdateByQueryRequest updateByQueryRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(updateByQueryRequest, RequestConverters::updateByQuery, options, BulkByScrollResponse::fromXContent, Collections.emptySet());
    }

    public final void updateByQueryAsync(UpdateByQueryRequest updateByQueryRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(updateByQueryRequest, RequestConverters::updateByQuery, options, BulkByScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final BulkByScrollResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(deleteByQueryRequest, RequestConverters::deleteByQuery, options, BulkByScrollResponse::fromXContent, Collections.emptySet());
    }

    public final void deleteByQueryAsync(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(deleteByQueryRequest, RequestConverters::deleteByQuery, options, BulkByScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse deleteByQueryRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleDeleteByQuery, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final void deleteByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleDeleteByQuery, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse updateByQueryRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleUpdateByQuery, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final void updateByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleUpdateByQuery, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse reindexRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleReindex, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final void reindexRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleReindex, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final boolean ping(RequestOptions options) throws IOException {
        return this.performRequest(new MainRequest(), (Req request) -> RequestConverters.ping(), options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public final boolean ping(Header ... headers) throws IOException {
        return this.performRequest(new MainRequest(), (Req request) -> RequestConverters.ping(), RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public final MainResponse info(RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(new MainRequest(), (Req request) -> RequestConverters.info(), options, MainResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final MainResponse info(Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(new MainRequest(), (Req request) -> RequestConverters.info(), MainResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final GetResponse get(GetRequest getRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(getRequest, RequestConverters::get, options, GetResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final GetResponse get(GetRequest getRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(getRequest, RequestConverters::get, GetResponse::fromXContent, Collections.singleton(404), headers);
    }

    public final void getAsync(GetRequest getRequest, RequestOptions options, ActionListener<GetResponse> listener) {
        this.performRequestAsyncAndParseEntity(getRequest, RequestConverters::get, options, GetResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final void getAsync(GetRequest getRequest, ActionListener<GetResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(getRequest, RequestConverters::get, GetResponse::fromXContent, listener, Collections.singleton(404), headers);
    }

    @Deprecated
    public final MultiGetResponse multiGet(MultiGetRequest multiGetRequest, RequestOptions options) throws IOException {
        return this.mget(multiGetRequest, options);
    }

    public final MultiGetResponse mget(MultiGetRequest multiGetRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(multiGetRequest, RequestConverters::multiGet, options, MultiGetResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final MultiGetResponse multiGet(MultiGetRequest multiGetRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(multiGetRequest, RequestConverters::multiGet, MultiGetResponse::fromXContent, Collections.singleton(404), headers);
    }

    @Deprecated
    public final void multiGetAsync(MultiGetRequest multiGetRequest, RequestOptions options, ActionListener<MultiGetResponse> listener) {
        this.mgetAsync(multiGetRequest, options, listener);
    }

    public final void mgetAsync(MultiGetRequest multiGetRequest, RequestOptions options, ActionListener<MultiGetResponse> listener) {
        this.performRequestAsyncAndParseEntity(multiGetRequest, RequestConverters::multiGet, options, MultiGetResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final void multiGetAsync(MultiGetRequest multiGetRequest, ActionListener<MultiGetResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(multiGetRequest, RequestConverters::multiGet, MultiGetResponse::fromXContent, listener, Collections.singleton(404), headers);
    }

    public final boolean exists(GetRequest getRequest, RequestOptions options) throws IOException {
        return this.performRequest(getRequest, RequestConverters::exists, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public final boolean exists(GetRequest getRequest, Header ... headers) throws IOException {
        return this.performRequest(getRequest, RequestConverters::exists, RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public final void existsAsync(GetRequest getRequest, RequestOptions options, ActionListener<Boolean> listener) {
        this.performRequestAsync(getRequest, RequestConverters::exists, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public final void existsAsync(GetRequest getRequest, ActionListener<Boolean> listener, Header ... headers) {
        this.performRequestAsync(getRequest, RequestConverters::exists, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet(), headers);
    }

    public final IndexResponse index(IndexRequest indexRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(indexRequest, RequestConverters::index, options, IndexResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final IndexResponse index(IndexRequest indexRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(indexRequest, RequestConverters::index, IndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void indexAsync(IndexRequest indexRequest, RequestOptions options, ActionListener<IndexResponse> listener) {
        this.performRequestAsyncAndParseEntity(indexRequest, RequestConverters::index, options, IndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void indexAsync(IndexRequest indexRequest, ActionListener<IndexResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(indexRequest, RequestConverters::index, IndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final UpdateResponse update(UpdateRequest updateRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(updateRequest, RequestConverters::update, options, UpdateResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final UpdateResponse update(UpdateRequest updateRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(updateRequest, RequestConverters::update, UpdateResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void updateAsync(UpdateRequest updateRequest, RequestOptions options, ActionListener<UpdateResponse> listener) {
        this.performRequestAsyncAndParseEntity(updateRequest, RequestConverters::update, options, UpdateResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void updateAsync(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(updateRequest, RequestConverters::update, UpdateResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final DeleteResponse delete(DeleteRequest deleteRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(deleteRequest, RequestConverters::delete, options, DeleteResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final DeleteResponse delete(DeleteRequest deleteRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(deleteRequest, RequestConverters::delete, DeleteResponse::fromXContent, Collections.singleton(404), headers);
    }

    public final void deleteAsync(DeleteRequest deleteRequest, RequestOptions options, ActionListener<DeleteResponse> listener) {
        this.performRequestAsyncAndParseEntity(deleteRequest, RequestConverters::delete, options, DeleteResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final void deleteAsync(DeleteRequest deleteRequest, ActionListener<DeleteResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(deleteRequest, RequestConverters::delete, DeleteResponse::fromXContent, listener, Collections.singleton(404), headers);
    }

    public final SearchResponse search(SearchRequest searchRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(searchRequest, RequestConverters::search, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final SearchResponse search(SearchRequest searchRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(searchRequest, RequestConverters::search, SearchResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void searchAsync(SearchRequest searchRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::search, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void searchAsync(SearchRequest searchRequest, ActionListener<SearchResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::search, SearchResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    @Deprecated
    public final MultiSearchResponse multiSearch(MultiSearchRequest multiSearchRequest, RequestOptions options) throws IOException {
        return this.msearch(multiSearchRequest, options);
    }

    public final MultiSearchResponse msearch(MultiSearchRequest multiSearchRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(multiSearchRequest, RequestConverters::multiSearch, options, MultiSearchResponse::fromXContext, Collections.emptySet());
    }

    @Deprecated
    public final MultiSearchResponse multiSearch(MultiSearchRequest multiSearchRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(multiSearchRequest, RequestConverters::multiSearch, MultiSearchResponse::fromXContext, Collections.emptySet(), headers);
    }

    @Deprecated
    public final void multiSearchAsync(MultiSearchRequest searchRequest, RequestOptions options, ActionListener<MultiSearchResponse> listener) {
        this.msearchAsync(searchRequest, options, listener);
    }

    public final void msearchAsync(MultiSearchRequest searchRequest, RequestOptions options, ActionListener<MultiSearchResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::multiSearch, options, MultiSearchResponse::fromXContext, listener, Collections.emptySet());
    }

    @Deprecated
    public final void multiSearchAsync(MultiSearchRequest searchRequest, ActionListener<MultiSearchResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::multiSearch, MultiSearchResponse::fromXContext, listener, Collections.emptySet(), headers);
    }

    @Deprecated
    public final SearchResponse searchScroll(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return this.scroll(searchScrollRequest, options);
    }

    public final SearchResponse scroll(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final SearchResponse searchScroll(SearchScrollRequest searchScrollRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, SearchResponse::fromXContent, Collections.emptySet(), headers);
    }

    @Deprecated
    public final void searchScrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.scrollAsync(searchScrollRequest, options, listener);
    }

    public final void scrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void searchScrollAsync(SearchScrollRequest searchScrollRequest, ActionListener<SearchResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, SearchResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, options, ClearScrollResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, ClearScrollResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void clearScrollAsync(ClearScrollRequest clearScrollRequest, RequestOptions options, ActionListener<ClearScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, options, ClearScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void clearScrollAsync(ClearScrollRequest clearScrollRequest, ActionListener<ClearScrollResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, ClearScrollResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final SearchTemplateResponse searchTemplate(SearchTemplateRequest searchTemplateRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(searchTemplateRequest, RequestConverters::searchTemplate, options, SearchTemplateResponse::fromXContent, Collections.emptySet());
    }

    public final void searchTemplateAsync(SearchTemplateRequest searchTemplateRequest, RequestOptions options, ActionListener<SearchTemplateResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchTemplateRequest, RequestConverters::searchTemplate, options, SearchTemplateResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ExplainResponse explain(ExplainRequest explainRequest, RequestOptions options) throws IOException {
        return this.performRequest(explainRequest, RequestConverters::explain, options, (Response response) -> {
            CheckedFunction entityParser = parser -> ExplainResponse.fromXContent(parser, RestHighLevelClient.convertExistsResponse(response));
            return this.parseEntity(response.getEntity(), entityParser);
        }, Collections.singleton(404));
    }

    public final void explainAsync(ExplainRequest explainRequest, RequestOptions options, ActionListener<ExplainResponse> listener) {
        this.performRequestAsync(explainRequest, RequestConverters::explain, options, (Response response) -> {
            CheckedFunction entityParser = parser -> ExplainResponse.fromXContent(parser, RestHighLevelClient.convertExistsResponse(response));
            return this.parseEntity(response.getEntity(), entityParser);
        }, listener, Collections.singleton(404));
    }

    public final RankEvalResponse rankEval(RankEvalRequest rankEvalRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(rankEvalRequest, RequestConverters::rankEval, options, RankEvalResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final RankEvalResponse rankEval(RankEvalRequest rankEvalRequest, Header ... headers) throws IOException {
        return this.performRequestAndParseEntity(rankEvalRequest, RequestConverters::rankEval, RankEvalResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void rankEvalAsync(RankEvalRequest rankEvalRequest, RequestOptions options, ActionListener<RankEvalResponse> listener) {
        this.performRequestAsyncAndParseEntity(rankEvalRequest, RequestConverters::rankEval, options, RankEvalResponse::fromXContent, listener, Collections.emptySet());
    }

    public final MultiSearchTemplateResponse msearchTemplate(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(multiSearchTemplateRequest, RequestConverters::multiSearchTemplate, options, MultiSearchTemplateResponse::fromXContext, Collections.emptySet());
    }

    public final void msearchTemplateAsync(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options, ActionListener<MultiSearchTemplateResponse> listener) {
        this.performRequestAsyncAndParseEntity(multiSearchTemplateRequest, RequestConverters::multiSearchTemplate, options, MultiSearchTemplateResponse::fromXContext, listener, Collections.emptySet());
    }

    @Deprecated
    public final void rankEvalAsync(RankEvalRequest rankEvalRequest, ActionListener<RankEvalResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(rankEvalRequest, RequestConverters::rankEval, RankEvalResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final FieldCapabilitiesResponse fieldCaps(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(fieldCapabilitiesRequest, RequestConverters::fieldCaps, options, FieldCapabilitiesResponse::fromXContent, Collections.emptySet());
    }

    public GetStoredScriptResponse getScript(GetStoredScriptRequest request, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(request, RequestConverters::getScript, options, GetStoredScriptResponse::fromXContent, Collections.emptySet());
    }

    public void getScriptAsync(GetStoredScriptRequest request, RequestOptions options, ActionListener<GetStoredScriptResponse> listener) {
        this.performRequestAsyncAndParseEntity(request, RequestConverters::getScript, options, GetStoredScriptResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteScript(DeleteStoredScriptRequest request, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(request, RequestConverters::deleteScript, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteScriptAsync(DeleteStoredScriptRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.performRequestAsyncAndParseEntity(request, RequestConverters::deleteScript, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putScript(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options) throws IOException {
        return this.performRequestAndParseEntity(putStoredScriptRequest, RequestConverters::putScript, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putScriptAsync(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.performRequestAsyncAndParseEntity(putStoredScriptRequest, RequestConverters::putScript, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public final void fieldCapsAsync(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options, ActionListener<FieldCapabilitiesResponse> listener) {
        this.performRequestAsyncAndParseEntity(fieldCapabilitiesRequest, RequestConverters::fieldCaps, options, FieldCapabilitiesResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores, Header ... headers) throws IOException {
        return (Resp)this.performRequest(request, requestConverter, (Response response) -> this.parseEntity(response.getEntity(), entityParser), ignores, headers);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return (Resp)this.performRequest(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), ignores);
    }

    protected final <Req extends Validatable, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return (Resp)this.performRequest(request, requestConverter, options, (Response response) -> this.parseEntity(response.getEntity(), entityParser), ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores, Header ... headers) throws IOException {
        return this.performRequest(request, requestConverter, RestHighLevelClient.optionsForHeaders(headers), responseConverter, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return this.internalPerformRequest(request, requestConverter, options, responseConverter, ignores);
    }

    protected final <Req extends Validatable, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            throw validationException.get();
        }
        return this.internalPerformRequest(request, requestConverter, options, responseConverter, ignores);
    }

    private <Req, Resp> Resp internalPerformRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Response response;
        Request req = requestConverter.apply(request);
        req.setOptions(options);
        try {
            response = this.client.performRequest(req);
        }
        catch (ResponseException e) {
            if (ignores.contains(e.getResponse().getStatusLine().getStatusCode())) {
                try {
                    return responseConverter.apply(e.getResponse());
                }
                catch (Exception innerException) {
                    throw this.parseResponseException(e);
                }
            }
            throw this.parseResponseException(e);
        }
        try {
            return responseConverter.apply(response);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse response body for " + response, e);
        }
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores, Header ... headers) {
        this.performRequestAsync(request, requestConverter, (Response response) -> this.parseEntity(response.getEntity(), entityParser), listener, ignores, headers);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores) {
        this.performRequestAsync(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), listener, ignores);
    }

    protected final <Req extends Validatable, Resp> void performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores) {
        this.performRequestAsync(request, requestConverter, options, (Response response) -> this.parseEntity(response.getEntity(), entityParser), listener, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores, Header ... headers) {
        this.performRequestAsync(request, requestConverter, RestHighLevelClient.optionsForHeaders(headers), responseConverter, listener, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            listener.onFailure(validationException);
            return;
        }
        this.internalPerformRequestAsync(request, requestConverter, options, responseConverter, listener, ignores);
    }

    protected final <Req extends Validatable, Resp> void performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            listener.onFailure(validationException.get());
            return;
        }
        this.internalPerformRequestAsync(request, requestConverter, options, responseConverter, listener, ignores);
    }

    private <Req, Resp> void internalPerformRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        Request req;
        try {
            req = requestConverter.apply(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        req.setOptions(options);
        ResponseListener responseListener = this.wrapResponseListener(responseConverter, listener, ignores);
        this.client.performRequestAsync(req, responseListener);
    }

    final <Resp> ResponseListener wrapResponseListener(final CheckedFunction<Response, Resp, IOException> responseConverter, final ActionListener<Resp> actionListener, final Set<Integer> ignores) {
        return new ResponseListener(){

            @Override
            public void onSuccess(Response response) {
                try {
                    actionListener.onResponse(responseConverter.apply(response));
                }
                catch (Exception e) {
                    IOException ioe = new IOException("Unable to parse response body for " + response, e);
                    this.onFailure(ioe);
                }
            }

            @Override
            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    Response response = responseException.getResponse();
                    if (ignores.contains(response.getStatusLine().getStatusCode())) {
                        try {
                            actionListener.onResponse(responseConverter.apply(response));
                        }
                        catch (Exception innerException) {
                            actionListener.onFailure(RestHighLevelClient.this.parseResponseException(responseException));
                        }
                    } else {
                        actionListener.onFailure(RestHighLevelClient.this.parseResponseException(responseException));
                    }
                } else {
                    actionListener.onFailure(exception);
                }
            }
        };
    }

    protected final ElasticsearchStatusException parseResponseException(ResponseException responseException) {
        ElasticsearchStatusException elasticsearchException;
        Response response = responseException.getResponse();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            elasticsearchException = new ElasticsearchStatusException(responseException.getMessage(), RestStatus.fromCode(response.getStatusLine().getStatusCode()), responseException, new Object[0]);
        } else {
            try {
                elasticsearchException = this.parseEntity(entity, BytesRestResponse::errorFromXContent);
                elasticsearchException.addSuppressed(responseException);
            }
            catch (Exception e) {
                RestStatus restStatus = RestStatus.fromCode(response.getStatusLine().getStatusCode());
                elasticsearchException = new ElasticsearchStatusException("Unable to parse response body", restStatus, responseException, new Object[0]);
                elasticsearchException.addSuppressed(e);
            }
        }
        return elasticsearchException;
    }

    protected final <Resp> Resp parseEntity(HttpEntity entity, CheckedFunction<XContentParser, Resp, IOException> entityParser) throws IOException {
        if (entity == null) {
            throw new IllegalStateException("Response body expected but not returned");
        }
        if (entity.getContentType() == null) {
            throw new IllegalStateException("Elasticsearch didn't return the [Content-Type] header, unable to parse response body");
        }
        XContentType xContentType = XContentType.fromMediaTypeOrFormat(entity.getContentType().getValue());
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + entity.getContentType().getValue());
        }
        try (XContentParser parser = xContentType.xContent().createParser(this.registry, DEPRECATION_HANDLER, entity.getContent());){
            Resp Resp = entityParser.apply(parser);
            return Resp;
        }
    }

    private static RequestOptions optionsForHeaders(Header[] headers) {
        RequestOptions.Builder options = RequestOptions.DEFAULT.toBuilder();
        for (Header header : headers) {
            Objects.requireNonNull(header, "header cannot be null");
            options.addHeader(header.getName(), header.getValue());
        }
        return options.build();
    }

    static boolean convertExistsResponse(Response response) {
        return response.getStatusLine().getStatusCode() == 200;
    }

    static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser<Object, Aggregation>> map = new HashMap<String, ContextParser<Object, Aggregation>>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent(p, (String)c));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent(p, (String)c));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent(p, (String)c));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent(p, (String)c));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent(p, (String)c));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent(p, (String)c));
        map.put("min", (p, c) -> ParsedMin.fromXContent(p, (String)c));
        map.put("max", (p, c) -> ParsedMax.fromXContent(p, (String)c));
        map.put("sum", (p, c) -> ParsedSum.fromXContent(p, (String)c));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent(p, (String)c));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent(p, (String)c));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent(p, (String)c));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent(p, (String)c));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent(p, (String)c));
        map.put("stats", (p, c) -> ParsedStats.fromXContent(p, (String)c));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent(p, (String)c));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent(p, (String)c));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent(p, (String)c));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent(p, (String)c));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent(p, (String)c));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent(p, (String)c));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent(p, (String)c));
        map.put("auto_date_histogram", (p, c) -> ParsedAutoDateHistogram.fromXContent(p, (String)c));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent(p, (String)c));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent(p, (String)c));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent(p, (String)c));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent(p, (String)c));
        map.put("nested", (p, c) -> ParsedNested.fromXContent(p, (String)c));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent(p, (String)c));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent(p, (String)c));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent(p, (String)c));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent(p, (String)c));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent(p, (String)c));
        map.put("range", (p, c) -> ParsedRange.fromXContent(p, (String)c));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent(p, (String)c));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent(p, (String)c));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent(p, (String)c));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent(p, (String)c));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent(p, (String)c));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent(p, (String)c));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent(p, (String)c));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent(p, (String)c));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent(p, (String)c));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent(p, (String)c));
        List<NamedXContentRegistry.Entry> entries = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("term", new String[0]), (parser, context) -> TermSuggestion.fromXContent(parser, (String)context)));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("phrase", new String[0]), (parser, context) -> PhraseSuggestion.fromXContent(parser, (String)context)));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("completion", new String[0]), (parser, context) -> CompletionSuggestion.fromXContent(parser, (String)context)));
        return entries;
    }

    static List<NamedXContentRegistry.Entry> getProvidedNamedXContents() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        for (NamedXContentProvider service : ServiceLoader.load(NamedXContentProvider.class)) {
            entries.addAll(service.getNamedXContentParsers());
        }
        return entries;
    }
}

