/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.client.ml.job.config.Job;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetJobStatsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField ALLOW_NO_JOBS = new ParseField("allow_no_jobs", new String[0]);
    public static final ConstructingObjectParser<GetJobStatsRequest, Void> PARSER = new ConstructingObjectParser("get_jobs_stats_request", a -> new GetJobStatsRequest((List)a[0]));
    private static final String ALL_JOBS = "_all";
    private final List<String> jobIds;
    private Boolean allowNoJobs;

    public static GetJobStatsRequest getAllJobStatsRequest() {
        return new GetJobStatsRequest(ALL_JOBS);
    }

    GetJobStatsRequest(List<String> jobIds) {
        if (jobIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("jobIds must not contain null values");
        }
        this.jobIds = new ArrayList<String>(jobIds);
    }

    public GetJobStatsRequest(String ... jobIds) {
        this(Arrays.asList(jobIds));
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public Boolean getAllowNoJobs() {
        return this.allowNoJobs;
    }

    public void setAllowNoJobs(boolean allowNoJobs) {
        this.allowNoJobs = allowNoJobs;
    }

    public int hashCode() {
        return Objects.hash(this.jobIds, this.allowNoJobs);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetJobStatsRequest that = (GetJobStatsRequest)other;
        return Objects.equals(this.jobIds, that.jobIds) && Objects.equals(this.allowNoJobs, that.allowNoJobs);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.jobIds));
        if (this.allowNoJobs != null) {
            builder.field(ALLOW_NO_JOBS.getPreferredName(), this.allowNoJobs);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> Arrays.asList(Strings.commaDelimitedListToStringArray(p.text())), Job.ID, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareBoolean(GetJobStatsRequest::setAllowNoJobs, ALLOW_NO_JOBS);
    }
}

