/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml.job.config;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.rest.action.admin.indices.RestAnalyzeAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CategorizationAnalyzerConfig
implements ToXContentFragment {
    public static final ParseField CATEGORIZATION_ANALYZER = new ParseField("categorization_analyzer", new String[0]);
    private static final ParseField TOKENIZER = RestAnalyzeAction.Fields.TOKENIZER;
    private static final ParseField TOKEN_FILTERS = RestAnalyzeAction.Fields.TOKEN_FILTERS;
    private static final ParseField CHAR_FILTERS = RestAnalyzeAction.Fields.CHAR_FILTERS;
    private final String analyzer;
    private final List<NameOrDefinition> charFilters;
    private final NameOrDefinition tokenizer;
    private final List<NameOrDefinition> tokenFilters;

    static CategorizationAnalyzerConfig buildFromXContentObject(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected start object but got [" + (Object)((Object)parser.currentToken()) + "]");
        }
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new IllegalArgumentException("Expected field name but got [" + (Object)((Object)parser.currentToken()) + "]");
        }
        parser.nextToken();
        CategorizationAnalyzerConfig categorizationAnalyzerConfig = CategorizationAnalyzerConfig.buildFromXContentFragment(parser);
        parser.nextToken();
        return categorizationAnalyzerConfig;
    }

    static CategorizationAnalyzerConfig buildFromXContentFragment(XContentParser parser) throws IOException {
        Builder builder = new Builder();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            builder.setAnalyzer(parser.text());
        } else {
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("[" + CATEGORIZATION_ANALYZER + "] should be analyzer's name or settings [" + (Object)((Object)token) + "]");
            }
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (CHAR_FILTERS.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            builder.addCharFilter(parser.text());
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT) {
                            builder.addCharFilter(parser.map());
                            continue;
                        }
                        throw new IllegalArgumentException("[" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] array element should contain char_filter's name or settings [" + (Object)((Object)token) + "]");
                    }
                    continue;
                }
                if (TOKENIZER.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        builder.setTokenizer(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        builder.setTokenizer(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException("[" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] should be tokenizer's name or settings [" + (Object)((Object)token) + "]");
                }
                if (!TOKEN_FILTERS.match(currentFieldName, parser.getDeprecationHandler()) || token != XContentParser.Token.START_ARRAY) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        builder.addTokenFilter(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        builder.addTokenFilter(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException("[" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] array element should contain token_filter's name or settings [" + (Object)((Object)token) + "]");
                }
            }
        }
        return builder.build();
    }

    private CategorizationAnalyzerConfig(String analyzer, List<NameOrDefinition> charFilters, NameOrDefinition tokenizer, List<NameOrDefinition> tokenFilters) {
        this.analyzer = analyzer;
        this.charFilters = Collections.unmodifiableList(charFilters);
        this.tokenizer = tokenizer;
        this.tokenFilters = Collections.unmodifiableList(tokenFilters);
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public List<NameOrDefinition> getCharFilters() {
        return this.charFilters;
    }

    public NameOrDefinition getTokenizer() {
        return this.tokenizer;
    }

    public List<NameOrDefinition> getTokenFilters() {
        return this.tokenFilters;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.analyzer != null) {
            builder.field(CATEGORIZATION_ANALYZER.getPreferredName(), this.analyzer);
        } else {
            builder.startObject(CATEGORIZATION_ANALYZER.getPreferredName());
            if (!this.charFilters.isEmpty()) {
                builder.startArray(CHAR_FILTERS.getPreferredName());
                for (NameOrDefinition charFilter : this.charFilters) {
                    charFilter.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.tokenizer != null) {
                builder.field(TOKENIZER.getPreferredName(), this.tokenizer);
            }
            if (!this.tokenFilters.isEmpty()) {
                builder.startArray(TOKEN_FILTERS.getPreferredName());
                for (NameOrDefinition tokenFilter : this.tokenFilters) {
                    tokenFilter.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategorizationAnalyzerConfig that = (CategorizationAnalyzerConfig)o;
        return Objects.equals(this.analyzer, that.analyzer) && Objects.equals(this.charFilters, that.charFilters) && Objects.equals(this.tokenizer, that.tokenizer) && Objects.equals(this.tokenFilters, that.tokenFilters);
    }

    public int hashCode() {
        return Objects.hash(this.analyzer, this.charFilters, this.tokenizer, this.tokenFilters);
    }

    public static class Builder {
        private String analyzer;
        private List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
        private NameOrDefinition tokenizer;
        private List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();

        public Builder() {
        }

        public Builder(CategorizationAnalyzerConfig categorizationAnalyzerConfig) {
            this.analyzer = categorizationAnalyzerConfig.analyzer;
            this.charFilters = new ArrayList<NameOrDefinition>(categorizationAnalyzerConfig.charFilters);
            this.tokenizer = categorizationAnalyzerConfig.tokenizer;
            this.tokenFilters = new ArrayList<NameOrDefinition>(categorizationAnalyzerConfig.tokenFilters);
        }

        public Builder setAnalyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder addCharFilter(String charFilter) {
            this.charFilters.add(new NameOrDefinition(charFilter));
            return this;
        }

        public Builder addCharFilter(Map<String, Object> charFilter) {
            this.charFilters.add(new NameOrDefinition(CHAR_FILTERS, charFilter));
            return this;
        }

        public Builder setTokenizer(String tokenizer) {
            this.tokenizer = new NameOrDefinition(tokenizer);
            return this;
        }

        public Builder setTokenizer(Map<String, Object> tokenizer) {
            this.tokenizer = new NameOrDefinition(TOKENIZER, tokenizer);
            return this;
        }

        public Builder addTokenFilter(String tokenFilter) {
            this.tokenFilters.add(new NameOrDefinition(tokenFilter));
            return this;
        }

        public Builder addTokenFilter(Map<String, Object> tokenFilter) {
            this.tokenFilters.add(new NameOrDefinition(TOKEN_FILTERS, tokenFilter));
            return this;
        }

        public CategorizationAnalyzerConfig build() {
            return new CategorizationAnalyzerConfig(this.analyzer, this.charFilters, this.tokenizer, this.tokenFilters);
        }
    }

    public static final class NameOrDefinition
    implements ToXContentFragment {
        public final String name;
        public final Settings definition;

        NameOrDefinition(String name) {
            this.name = Objects.requireNonNull(name);
            this.definition = null;
        }

        NameOrDefinition(ParseField field, Map<String, Object> definition) {
            this.name = null;
            Objects.requireNonNull(definition);
            try {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                builder.map(definition);
                this.definition = Settings.builder().loadFromSource(Strings.toString(builder), builder.contentType()).build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse [" + definition + "] in [" + field.getPreferredName() + "]", e);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.definition == null) {
                builder.value(this.name);
            } else {
                builder.startObject();
                this.definition.toXContent(builder, params);
                builder.endObject();
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameOrDefinition that = (NameOrDefinition)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.definition);
        }

        public String toString() {
            if (this.definition == null) {
                return this.name;
            }
            return this.definition.toDelimitedString(';');
        }
    }
}

