/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing.allocation.command;

import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.routing.RoutingNode;
import conductor.org.elasticsearch.cluster.routing.RoutingNodes;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.ShardRoutingState;
import conductor.org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import conductor.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import conductor.org.elasticsearch.cluster.routing.allocation.command.AbstractAllocateAllocationCommand;
import conductor.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.index.shard.ShardNotFoundException;
import java.io.IOException;
import java.util.List;

public class AllocateReplicaAllocationCommand
extends AbstractAllocateAllocationCommand {
    public static final String NAME = "allocate_replica";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_replica", new String[0]);
    private static final ObjectParser<Builder, Void> REPLICA_PARSER = AllocateReplicaAllocationCommand.createAllocateParser("allocate_replica");

    public AllocateReplicaAllocationCommand(String index, int shardId, String node) {
        super(index, shardId, node);
    }

    public AllocateReplicaAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String name() {
        return NAME;
    }

    public static AllocateReplicaAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        ShardRouting primaryShardRouting;
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            primaryShardRouting = allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        if (primaryShardRouting.unassigned()) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "trying to allocate a replica shard [" + this.index + "][" + this.shardId + "], while corresponding primary shard is still unassigned");
        }
        List<ShardRouting> replicaShardRoutings = allocation.routingTable().shardRoutingTable(this.index, this.shardId).replicaShardsWithState(ShardRoutingState.UNASSIGNED);
        if (replicaShardRoutings.isEmpty()) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "all copies of [" + this.index + "][" + this.shardId + "] are already assigned. Use the move allocation command instead");
        }
        ShardRouting shardRouting = replicaShardRoutings.get(0);
        Decision decision = allocation.deciders().canAllocate(shardRouting, routingNode, allocation);
        if (decision.type() == Decision.Type.NO) {
            if (explain) {
                return new RerouteExplanation(this, decision);
            }
            throw new IllegalArgumentException("[" + this.name() + "] allocation of [" + this.index + "][" + this.shardId + "] on node " + discoNode + " is not allowed, reason: " + decision);
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting);
        return new RerouteExplanation(this, decision);
    }

    protected static class Builder
    extends AbstractAllocateAllocationCommand.Builder<AllocateReplicaAllocationCommand> {
        protected Builder() {
        }

        public Builder parse(XContentParser parser) throws IOException {
            return REPLICA_PARSER.parse(parser, this, null);
        }

        @Override
        public AllocateReplicaAllocationCommand build() {
            this.validate();
            return new AllocateReplicaAllocationCommand(this.index, this.shard, this.node);
        }
    }
}

